/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.es2es.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.interaction.services.SequenceMessageExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RoleAllocation;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.projection.common.resolver.ResolverFinalizer;
import org.polarsys.capella.core.projection.scenario.CommonScenarioHelper;
import org.polarsys.capella.core.projection.scenario.Messages;
import org.polarsys.capella.core.projection.scenario.ScenarioFinalizer;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.helpers.Query;

public class ScenarioHelper {
    public static List<AbstractInstance> getRelatedInstances(Scenario scenario, ITransfo transfo_p) {
        ArrayList<AbstractInstance> partBounds = new ArrayList();
        for (InteractionFragment fragment : scenario.getOwnedInteractionFragments()) {
            AbstractEventOperation transitionedOperation;
            AbstractEnd end;
            AbstractInstance instance;
            if (!(fragment instanceof AbstractEnd) || (instance = ScenarioHelper.getRelatedInstance(end = (AbstractEnd)fragment, end, transitionedOperation = ScenarioHelper.getTransitionedOperation((EObject)end, transfo_p), transfo_p)) == null) continue;
            partBounds.add(instance);
        }
        partBounds = ListExt.removeDuplicates(partBounds);
        return partBounds;
    }

    public static List<AbstractInstance> getRelatedInstances(InstanceRole role, ITransfo transfo_p) {
        ArrayList<AbstractInstance> partBounds = new ArrayList();
        for (AbstractEnd end : role.getAbstractEnds()) {
            AbstractEventOperation transitionedOperation;
            AbstractInstance instance = ScenarioHelper.getRelatedInstance(end, end, transitionedOperation = ScenarioHelper.getTransitionedOperation((EObject)end, transfo_p), transfo_p);
            if (instance != null) {
                partBounds.add(instance);
                continue;
            }
            ScenarioFinalizer.registerUnwantedObject((EObject)end.getEvent(), transfo_p);
        }
        if (partBounds.size() == 0 && role.getRepresentedInstance() != null) {
            String messageTxxt = Messages.Scenario_MultipleTransitionedElements;
            List availables = Query.retrieveTransformedElements((EObject)role.getRepresentedInstance(), (ITransfo)transfo_p, (EClass)InformationPackage.Literals.ABSTRACT_INSTANCE);
            if (availables.size() == 0 && role.getRepresentedInstance() instanceof Part) {
                for (PartitionableElement element : Query.retrieveTransformedElements((EObject)role.getRepresentedInstance().getAbstractType(), (ITransfo)transfo_p, (EClass)InformationPackage.Literals.PARTITIONABLE_ELEMENT)) {
                    availables.addAll(element.getRepresentingPartitions());
                }
            }
            if (availables.size() <= 1) {
                partBounds.addAll(availables);
            } else {
                List res;
                ResolverFinalizer resolver = ResolverFinalizer.getResolver((ITransfo)transfo_p);
                if (resolver != null && (res = resolver.resolve((EObject)role.getRepresentedInstance(), availables, CommonScenarioHelper.getTitle(transfo_p), messageTxxt, false, transfo_p, new EObject[]{role.getRepresentedInstance()})) != null && res.size() > 0) {
                    partBounds.add((AbstractInstance)res.get(0));
                }
            }
        }
        partBounds = ListExt.removeDuplicates(partBounds);
        return partBounds;
    }

    public static AbstractInstance getRelatedInstance(AbstractEnd end, AbstractEnd sourceEnd, AbstractEventOperation operation_p, ITransfo transfo_p) {
        List<AbstractInstance> partBounds = new ArrayList<AbstractInstance>();
        boolean isLinked = false;
        List<AbstractInstance> relatedParts = ScenarioHelper.getRelatedInstances(end, (EObject)operation_p, transfo_p);
        if (sourceEnd != null) {
            for (AbstractInstance relatedPart : relatedParts) {
                for (AbstractInstance parent : ScenarioHelper.getRelatedElements(relatedPart)) {
                    for (InstanceRole relatedRole : sourceEnd.getCoveredInstanceRoles()) {
                        if (!RefinementLinkExt.isLinkedTo((TraceableElement)parent, (TraceableElement)relatedRole.getRepresentedInstance())) continue;
                        isLinked = true;
                        partBounds.add(relatedPart);
                    }
                }
            }
        }
        if (!isLinked) {
            partBounds.addAll(relatedParts);
        }
        if ((partBounds = ListExt.removeDuplicates(partBounds)).size() == 0) {
            return null;
        }
        if (partBounds.size() == 1) {
            return (AbstractInstance)partBounds.get(0);
        }
        ResolverFinalizer resolver = ResolverFinalizer.getResolver((ITransfo)transfo_p);
        if (resolver == null) {
            return (AbstractInstance)partBounds.get(0);
        }
        SequenceMessage message = ScenarioHelper.getRelatedSequenceMessage(sourceEnd);
        boolean isSource = ScenarioHelper.isEndRelatedToSendingRole(end);
        String messageTxt = NLS.bind((String)(isSource ? Messages.Scenario_SourceMessage : Messages.Scenario_TargetMessage), (Object[])new Object[]{ScenarioHelper.getPosition(message), EObjectLabelProviderHelper.getText((EObject)message), EObjectLabelProviderHelper.getText((EObject)operation_p), EObjectLabelProviderHelper.getMetaclassLabel((EObject)operation_p, (boolean)true)});
        MessageEnd context = isSource ? message.getSendingEnd() : message.getReceivingEnd();
        return (Partition)resolver.resolve((EObject)operation_p, partBounds, CommonScenarioHelper.getTitle(transfo_p), messageTxt, false, transfo_p, new EObject[]{message, operation_p, context}).get(0);
    }

    private static Collection<AbstractInstance> getRelatedElements(AbstractInstance relatedPart_p) {
        ArrayList<AbstractInstance> parents = new ArrayList<AbstractInstance>();
        parents.add(relatedPart_p);
        if (relatedPart_p instanceof Part) {
            parents.addAll(ComponentExt.getPartAncestors((Part)((Part)relatedPart_p), (boolean)true));
        }
        return parents;
    }

    private static String getPosition(SequenceMessage message_p) {
        EObject container = message_p.eContainer();
        EStructuralFeature reference = message_p.eContainingFeature();
        Object value = null;
        int position = 1;
        if (container != null && reference != null && reference.isMany() && (value = container.eGet(reference)) instanceof List) {
            position = ((List)value).indexOf(message_p) + 1;
        }
        switch (position % 10) {
            case 1: {
                return String.valueOf(position) + Messages.Scenario_First;
            }
            case 2: {
                return String.valueOf(position) + Messages.Scenario_Second;
            }
            case 3: {
                return String.valueOf(position) + Messages.Scenario_Third;
            }
        }
        return String.valueOf(position) + Messages.Scenario_Nth;
    }

    public static List<AbstractInstance> getRelatedInstances(AbstractEnd end, EObject operation, ITransfo transfo_p) {
        Scenario scenario = (Scenario)transfo_p.get((Object)"transfoSource");
        boolean shouldRetrieveAllocating = !TransitionHelper.getService().isFunctionalScenario(scenario);
        Event event = end.getEvent();
        boolean isSource = false;
        isSource = event instanceof EventSentOperation;
        if (end instanceof MessageEnd && ((MessageEnd)end).getMessage() != null) {
            isSource = ((MessageEnd)end).getMessage().getKind() == MessageKind.REPLY ? !isSource : isSource;
        }
        ArrayList<AbstractInstance> partBounds = new ArrayList<AbstractInstance>();
        if (operation != null) {
            if (operation instanceof ComponentExchange) {
                Part partBound = null;
                Component typeBound = null;
                ComponentExchange connection = (ComponentExchange)operation;
                if (isSource || !connection.isOriented()) {
                    partBound = ComponentExchangeExt.getSourcePart((ComponentExchange)((ComponentExchange)operation));
                    typeBound = ComponentExchangeExt.getSourceComponent((ComponentExchange)((ComponentExchange)operation));
                    if (partBound != null) {
                        partBounds.add((AbstractInstance)partBound);
                    } else if (typeBound != null) {
                        partBounds.addAll((Collection<AbstractInstance>)typeBound.getRepresentingPartitions());
                    }
                }
                if (!isSource || !connection.isOriented()) {
                    partBound = ComponentExchangeExt.getTargetPart((ComponentExchange)((ComponentExchange)operation));
                    typeBound = ComponentExchangeExt.getTargetComponent((ComponentExchange)((ComponentExchange)operation));
                    if (partBound != null) {
                        partBounds.add((AbstractInstance)partBound);
                    } else if (typeBound != null) {
                        partBounds.addAll((Collection<AbstractInstance>)typeBound.getRepresentingPartitions());
                    }
                }
            } else if (operation instanceof FunctionalExchange) {
                FunctionalExchange exchange = (FunctionalExchange)operation;
                AbstractFunction function = null;
                ActivityNode current = exchange.getTarget();
                if (isSource) {
                    current = exchange.getSource();
                }
                if (current != null) {
                    function = current instanceof AbstractFunction ? (AbstractFunction)current : (AbstractFunction)EcoreUtil2.getFirstContainer((EObject)current, (EClass)FaPackage.Literals.ABSTRACT_FUNCTION);
                }
                if (function != null) {
                    if (shouldRetrieveAllocating) {
                        for (ComponentFunctionalAllocation allocation : function.getComponentFunctionalAllocations()) {
                            if (allocation.getBlock() == null || !(allocation.getBlock() instanceof PartitionableElement)) continue;
                            partBounds.addAll((Collection<AbstractInstance>)((PartitionableElement)allocation.getBlock()).getRepresentingPartitions());
                        }
                        if (function instanceof OperationalActivity) {
                            for (ComponentFunctionalAllocation allocation : ((OperationalActivity)function).getActivityAllocations()) {
                                Role allocatingRole = allocation.getRole();
                                if (allocatingRole == null) continue;
                                for (RoleAllocation roleAllocation : allocatingRole.getRoleAllocations()) {
                                    if (roleAllocation.getEntity() == null) continue;
                                    partBounds.addAll((Collection<AbstractInstance>)roleAllocation.getEntity().getRepresentingPartitions());
                                }
                            }
                        }
                    } else {
                        partBounds.add((AbstractInstance)function);
                    }
                }
            }
        }
        return partBounds;
    }

    public static AbstractEventOperation getTransitionedOperation(EObject element_p, ITransfo transfo_p) {
        if (element_p instanceof ExecutionEnd) {
            return ScenarioHelper.getTransitionedOperation((EObject)((ExecutionEnd)element_p).getExecution().getStart(), transfo_p);
        }
        if (element_p instanceof AbstractEnd) {
            return ScenarioHelper.getTransitionedOperation((EObject)((AbstractEnd)element_p).getEvent(), transfo_p);
        }
        if (element_p instanceof Event) {
            SequenceMessage message = ScenarioHelper.getRelatedSequenceMessage((Event)element_p);
            AbstractEventOperation operation = CommonScenarioHelper.getOperation(element_p, transfo_p);
            String messageTxxt = Messages.Scenario_MultipleTransitionedElements;
            List availables = Query.retrieveTransformedElements((EObject)operation, (ITransfo)transfo_p, (EClass)InformationPackage.Literals.ABSTRACT_EVENT_OPERATION);
            if (availables.size() == 0) {
                return null;
            }
            if (availables.size() == 1) {
                return (AbstractEventOperation)availables.get(0);
            }
            ResolverFinalizer resolver = ResolverFinalizer.getResolver((ITransfo)transfo_p);
            if (resolver == null) {
                return (AbstractEventOperation)availables.get(0);
            }
            List res = resolver.resolve((EObject)operation, availables, CommonScenarioHelper.getTitle(transfo_p), messageTxxt, false, transfo_p, new EObject[]{operation, message});
            if (res != null && res.size() > 0) {
                return (AbstractEventOperation)res.get(0);
            }
        }
        return null;
    }

    public static SequenceMessage getRelatedSequenceMessage(Event event_p) {
        for (EObject referencer : EObjectExt.getReferencers((EObject)event_p, (EReference)InteractionPackage.Literals.ABSTRACT_END__EVENT)) {
            if (!(referencer instanceof AbstractEnd)) continue;
            AbstractEnd end = (AbstractEnd)referencer;
            return ScenarioHelper.getRelatedSequenceMessage(end);
        }
        return null;
    }

    public static SequenceMessage getRelatedSequenceMessage(AbstractEnd end_p) {
        ExecutionEnd eend;
        AbstractEnd end = end_p;
        if (end instanceof ExecutionEnd && (eend = (ExecutionEnd)end).getExecution() != null) {
            end = (AbstractEnd)eend.getExecution().getStart();
        }
        if (end != null && end instanceof MessageEnd) {
            MessageEnd mend = (MessageEnd)end;
            SequenceMessage message = mend.getMessage();
            if (message.getKind() == MessageKind.REPLY) {
                message = SequenceMessageExt.getOppositeSequenceMessage((SequenceMessage)message);
            }
            return message;
        }
        return null;
    }

    public static boolean isEndRelatedToSendingRole(AbstractEnd end_p) {
        ExecutionEnd eend;
        AbstractEnd end = end_p;
        if (end instanceof ExecutionEnd && (eend = (ExecutionEnd)end).getExecution() != null) {
            end = (AbstractEnd)eend.getExecution().getStart();
        }
        if (end != null && end instanceof MessageEnd) {
            MessageEnd mend = (MessageEnd)end;
            SequenceMessage message = mend.getMessage();
            if (message.getKind() == MessageKind.REPLY) {
                return mend.getEvent() instanceof EventReceiptOperation;
            }
            return mend.getEvent() instanceof EventSentOperation;
        }
        return false;
    }
}

