/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.fs2es.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RoleAllocation;
import org.polarsys.capella.core.projection.common.context.IContext;
import org.polarsys.capella.core.projection.common.resolver.ResolverFinalizer;
import org.polarsys.capella.core.projection.scenario.CommonScenarioHelper;
import org.polarsys.capella.core.projection.scenario.Messages;
import org.polarsys.capella.core.projection.scenario.fs2es.rules.FS2CESFinalizer;
import org.polarsys.capella.core.projection.scenario.handlers.ScenarioHorizontalHandler;
import org.polarsys.capella.core.tiger.ITransfo;

public class ScenarioFS2ESHandler
extends ScenarioHorizontalHandler {
    private Collection<PartitionableElement> getAllocatingBlocks(AbstractFunction function_p) {
        HashSet<PartitionableElement> allocatingBlocks = new HashSet<PartitionableElement>();
        for (ComponentFunctionalAllocation allocation : function_p.getComponentFunctionalAllocations()) {
            AbstractFunctionalBlock block = allocation.getBlock();
            if (block == null || !(block instanceof PartitionableElement)) continue;
            PartitionableElement element = (PartitionableElement)block;
            allocatingBlocks.add(element);
        }
        if (function_p instanceof OperationalActivity) {
            for (ComponentFunctionalAllocation allocation : ((OperationalActivity)function_p).getActivityAllocations()) {
                Role allocatingRole = allocation.getRole();
                if (allocatingRole == null) continue;
                for (RoleAllocation roleAllocation : allocatingRole.getRoleAllocations()) {
                    if (roleAllocation.getEntity() == null) continue;
                    allocatingBlocks.add((PartitionableElement)roleAllocation.getEntity());
                }
            }
        }
        return allocatingBlocks;
    }

    private AbstractInstance getRelatedPart(InstanceRole role, AbstractFunction function_p, ITransfo transfo_p) {
        ArrayList elements = new ArrayList();
        boolean isMultiAllocation = false;
        int nbAllocation = 0;
        Collection<PartitionableElement> allocatingBlocks = this.getAllocatingBlocks(function_p);
        Iterator leafs = FunctionExt.getAllLeafAbstractFunctions((AbstractFunction)function_p).iterator();
        if (leafs.hasNext()) {
            AbstractFunction leaf = (AbstractFunction)leafs.next();
            Collection<PartitionableElement> leafAllocatingBlocks = this.getAllocatingBlocks(leaf);
            while (leafs.hasNext() && leafAllocatingBlocks.size() > 0) {
                leaf = (AbstractFunction)leafs.next();
                leafAllocatingBlocks.retainAll(this.getAllocatingBlocks(leaf));
            }
            allocatingBlocks.addAll(leafAllocatingBlocks);
        }
        for (PartitionableElement element : allocatingBlocks) {
            if (element.getRepresentingPartitions().size() <= 0) continue;
            ++nbAllocation;
            elements.addAll(element.getRepresentingPartitions());
        }
        boolean bl = isMultiAllocation = nbAllocation > 1;
        if (elements.size() == 0) {
            return null;
        }
        if (elements.size() == 1) {
            return (AbstractInstance)elements.get(0);
        }
        ResolverFinalizer resolver = ResolverFinalizer.getResolver((ITransfo)transfo_p);
        if (resolver == null) {
            return (AbstractInstance)elements.get(0);
        }
        String message = "";
        message = isMultiAllocation ? Messages.Rule_InstanceRole_AllocatedMoreThanOnce : Messages.Rule_InstanceRole_AllocatingMultipart;
        message = String.valueOf(message) + Messages.Rule_InstanceRole_Selection;
        message = NLS.bind((String)message, (Object)EObjectLabelProviderHelper.getText((EObject)role), (Object)EObjectLabelProviderHelper.getText((EObject)role));
        List result = resolver.resolve((EObject)function_p, elements, CommonScenarioHelper.getTitle(transfo_p), message, false, transfo_p, new EObject[]{function_p});
        if (result.size() > 0) {
            return (AbstractInstance)result.get(0);
        }
        return null;
    }

    @Override
    public List<AbstractInstance> getRelatedInstances(InstanceRole role_p, IContext context_p) {
        AbstractFunction function = (AbstractFunction)role_p.getRepresentedInstance();
        AbstractInstance part = this.getRelatedPart(role_p, function, context_p.getTransfo());
        if (part != null) {
            return Collections.singletonList(part);
        }
        return Collections.emptyList();
    }

    @Override
    public InstanceRole getInstanceRole(AbstractInstance tracedInstance_p, IContext context_p) {
        return FS2CESFinalizer.getInstanceRole(tracedInstance_p);
    }
}

