/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class Matcher {
    private String id;
    private Pattern idPattern;
    private String name;
    private Pattern namePattern;
    private String version;
    private String domain;
    private Pattern domainPattern;
    private final List<String> tags = new ArrayList<String>();
    private final List<String> matchedIds = new ArrayList<String>();
    private final List<String> userInConcerns = new ArrayList<String>();
    private final List<String> usedInConcerns = new ArrayList<String>();
    private final List<String> concerns = new ArrayList<String>();

    public Matcher(SearchCriteria criteria) {
        this.id = criteria.getId();
        this.idPattern = this.createPattern(this.id);
        this.name = criteria.getName();
        this.namePattern = this.createPattern(this.name);
        this.version = criteria.getVersion();
        this.domain = criteria.getDomain();
        this.domainPattern = this.createPattern(this.domain);
        this.tags.addAll(criteria.getTags());
        this.userInConcerns.addAll(criteria.getUserInConcerns());
        this.usedInConcerns.addAll(criteria.getUsedInConcerns());
        this.concerns.addAll(criteria.getConcerns());
    }

    private Pattern createPattern(String regex) {
        if (regex == null || "".equals(regex)) {
            return null;
        }
        return Pattern.compile(regex);
    }

    public boolean matchUserConcerns(Set<String> concerns) {
        if (concerns == null) {
            return this.userInConcerns.isEmpty();
        }
        for (String concern : this.userInConcerns) {
            if (concerns.contains(concern)) continue;
            return false;
        }
        return true;
    }

    public boolean matchUsedConcerns(Set<String> concerns) {
        if (concerns == null) {
            return this.usedInConcerns.isEmpty();
        }
        for (String concern : this.usedInConcerns) {
            if (concerns.contains(concern)) continue;
            return false;
        }
        return true;
    }

    public boolean internalMatchUsedConcerns(List<String> criteria, Set<String> concerns) {
        if (concerns == null) {
            return criteria.isEmpty();
        }
        for (String concern : criteria) {
            if (concerns.contains(concern)) continue;
            return false;
        }
        return true;
    }

    public boolean matchConcerns(Set<String> usedConcerns, Set<String> userConcerns) {
        if (!this.internalMatchUsedConcerns(this.userInConcerns, userConcerns)) {
            return false;
        }
        if (!this.internalMatchUsedConcerns(this.usedInConcerns, usedConcerns)) {
            return false;
        }
        if (this.concerns.isEmpty()) {
            return true;
        }
        HashSet<String> all = new HashSet<String>();
        if (userConcerns != null) {
            all.addAll(userConcerns);
        }
        if (usedConcerns != null) {
            all.addAll(usedConcerns);
        }
        return this.internalMatchUsedConcerns(this.concerns, all);
    }

    public boolean matchResource(Resource res) {
        if (this.isAlreadyMatched(res)) {
            return false;
        }
        if (this.idPattern != null && !this.idPattern.matcher(res.getId()).matches()) {
            return false;
        }
        if (this.namePattern != null && !this.namePattern.matcher(res.getName()).matches()) {
            return false;
        }
        if (!(this.domainPattern == null || res.getDomain() != null && this.domainPattern.matcher(res.getDomain()).matches())) {
            return false;
        }
        if (!(this.version == null || "".equals(this.version) || res.getVersion() != null && res.getVersion().equals(this.version))) {
            return false;
        }
        for (String tag : this.tags) {
            if (res.getTags().contains(tag)) continue;
            return false;
        }
        this.matchedIds.add(res.getId());
        return true;
    }

    private boolean isAlreadyMatched(Resource res) {
        return this.matchedIds.contains(res.getId());
    }
}

