/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.Messages;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.AddTraceWizard;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.components.CapellaModelTreeViewer;

public class ViewCapellaModelPage
extends WizardPage {
    public AddTraceWizard _parentWizard;
    private SystemEngineering _system;
    CapellaModelTreeViewer _capellaModelViewer;

    public ViewCapellaModelPage(String pageName_p, SystemEngineering sysEng_p, AddTraceWizard parentWizard_p) {
        super(pageName_p);
        this._system = sysEng_p;
        this._parentWizard = parentWizard_p;
    }

    protected Composite createInternalComposite(Composite parent_p) {
        Composite composite = new Composite(parent_p, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    public void createControl(Composite parent_p) {
        FillLayout horizontalFillLayout = new FillLayout(256);
        Composite composite = this.createInternalComposite(parent_p);
        Composite capellaTreeComposite = new Composite(composite, 0);
        capellaTreeComposite.setLayout((Layout)horizontalFillLayout);
        capellaTreeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this._capellaModelViewer = new CapellaModelTreeViewer(this._system);
        this._capellaModelViewer._currentNamedElement = this._parentWizard.getWorkingNamedElement();
        this._capellaModelViewer.getControl(capellaTreeComposite);
        this._capellaModelViewer._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                Object elem;
                ISelection selection = event_p.getSelection();
                if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (elem = ((IStructuredSelection)selection).getFirstElement()) instanceof NamedElement) {
                    if (ViewCapellaModelPage.this.checkElement((NamedElement)elem)) {
                        ViewCapellaModelPage.this.setPageComplete(true);
                        ViewCapellaModelPage.this._parentWizard.setCurrentNamedElement((NamedElement)elem);
                        ViewCapellaModelPage.this.setMessage(null);
                    } else {
                        ViewCapellaModelPage.this.setPageComplete(false);
                        ViewCapellaModelPage.this.setMessage(Messages.getString("AddTraceWizard.warning_element_already_exists"), 2);
                    }
                }
            }
        });
        this.setControl((Control)composite);
    }

    public boolean checkElement(NamedElement element_p) {
        NamedElement currentElt = this._parentWizard.getWorkingNamedElement();
        if (currentElt.equals(element_p)) {
            return false;
        }
        for (AbstractTrace trace : currentElt.getIncomingTraces()) {
            if (trace.getSourceElement() == element_p) {
                return false;
            }
            if (trace.getTargetElement() != element_p) continue;
            return false;
        }
        for (AbstractTrace trace : currentElt.getOutgoingTraces()) {
            if (trace.getSourceElement() == element_p) {
                return false;
            }
            if (trace.getTargetElement() != element_p) continue;
            return false;
        }
        return true;
    }
}

