/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.validation.design.consistency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.common.re.RePackage;
import org.polarsys.capella.common.re.launcher.Rpl2RecConformanceCheckLauncher;

public class DCON_02_Rpl2RecConformanceConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        CatalogElement catalogElement = (CatalogElement)ctx.getTarget();
        if (catalogElement.getKind() == CatalogElementKind.RPL) {
            return this.validateRPL(ctx, catalogElement);
        }
        if (catalogElement.getKind() == CatalogElementKind.REC) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            statuses.add(ctx.createSuccessStatus());
            List allRPLs = EObjectExt.getReferencers((EObject)catalogElement, (EClass)RePackage.eINSTANCE.getCatalogElement(), (EReference)RePackage.eINSTANCE.getCatalogElement_Origin());
            ctx.skipCurrentConstraintForAll((Collection)allRPLs);
            for (EObject rpl : allRPLs) {
                statuses.add(this.validateRPL(ctx, (CatalogElement)rpl));
            }
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
        }
        catalogElement.getKind();
        return ctx.createSuccessStatus();
    }

    private IStatus validateRPL(IValidationContext ctx, CatalogElement rpl) {
        ArrayList<CatalogElement> selection = new ArrayList<CatalogElement>();
        selection.add(rpl);
        Rpl2RecConformanceCheckLauncher launcher = new Rpl2RecConformanceCheckLauncher();
        launcher.run(selection, false, (IProgressMonitor)new NullProgressMonitor());
        if (!launcher.isConform()) {
            return this.createFailureStatus(ctx, (EObject)rpl, rpl, rpl.getOrigin());
        }
        return ctx.createSuccessStatus();
    }

    private IStatus createFailureStatus(IValidationContext ctx, EObject target, Object ... messageArgs) {
        IConstraintDescriptor constraintDescriptor = ConstraintRegistry.getInstance().getDescriptor(ctx.getCurrentConstraintId());
        return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)target, (Collection)ctx.getResultLocus(), (String)constraintDescriptor.getMessagePattern(), (Object[])messageArgs);
    }
}

