/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commandline.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.bundle.FeatureHelper;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.commandline.core.CommandLineArgumentHelper;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.commandline.core.CommandLineMode;
import org.polarsys.capella.core.commandline.core.ICommandLine;
import org.polarsys.capella.core.commandline.core.Messages;
import org.polarsys.capella.core.commandline.core.WorkbenchHelper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaFeatureHelper;

public class AbstractCommandLine
implements ICommandLine {
    public static int FATAL = 8;
    protected static Logger __logger;
    protected static CommandLineArgumentHelper argHelper;
    protected CommandLineMode mode;
    private List<String> importedProjects = new ArrayList<String>();

    public AbstractCommandLine() {
        argHelper = CommandLineArgumentHelper.getInstance();
        __logger = ReportManagerRegistry.getInstance().subscribe("Default");
    }

    @Override
    public void parseContext(IApplicationContext context) throws CommandLineException {
        String[] args = CommandLineArgumentHelper.parseContext(context);
        argHelper.parseArgs(args);
    }

    @Override
    public void checkArgs(IApplicationContext context) throws CommandLineException {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exception) {
            this.logErrorAndThrowException(Messages.refresh_problem);
        }
        if (this.isEmtyOrNull(argHelper.getFilePath())) {
            this.logErrorAndThrowException(Messages.representation_mandatory);
        }
        if (this.isEmtyOrNull(argHelper.getOutputFolder())) {
            this.logErrorAndThrowException(Messages.outputfolder_mandatory);
        }
        if (this.isEmtyOrNull(argHelper.getImportProjects())) {
            this.setMode(CommandLineMode.NO_IMPORT);
            this.checkFilePath();
            if (!argHelper.isCreateFolder()) {
                this.checkoutputFolder();
            }
        } else if (!this.isEmtyOrNull(argHelper.getImportProjects())) {
            this.setMode(CommandLineMode.IMPORT);
        }
    }

    @Override
    public void prepare(IApplicationContext context) throws CommandLineException {
        if (!CommandLineMode.NO_IMPORT.equals((Object)this.mode) && CommandLineMode.IMPORT.equals((Object)this.mode)) {
            try {
                this.importProjects(this.toList(argHelper.getImportProjects()));
            }
            catch (CoreException exception) {
                throw new CommandLineException(exception.getMessage());
            }
        }
        if (argHelper.isCreateFolder()) {
            this.createOutputFolder(argHelper.getOutputFolder());
        }
        if (!this.projectVersionIsCompliant()) {
            this.logErrorAndThrowException(Messages.Error_versionCompliancy);
        }
    }

    public boolean projectVersionIsCompliant() throws CommandLineException {
        String projectName = AbstractCommandLine.getProjectName(argHelper.getFilePath());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            this.logError(String.valueOf(Messages.project) + projectName + Messages.not_exist);
        } else {
            try {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                StringBuilder loggerMessage = new StringBuilder("HTMLCommandLine.checkArgs(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
            }
            List<IFile> melodymodellerFiles = this.getCapellamodellerFiles(project);
            for (IFile modeller : melodymodellerFiles) {
                this.compliancyCheck(modeller);
            }
        }
        return true;
    }

    private void compliancyCheck(IFile modeller) throws CommandLineException {
        String fileToMigrateVersion = CapellaFeatureHelper.getDetectedVersion((IFile)modeller).substring(0, 5);
        int fileToMigrateRelease = this.getReleaseVersion(fileToMigrateVersion);
        int fileToMigrateMajorVersion = this.getMajorVersion(fileToMigrateVersion);
        String version = FeatureHelper.getCapellaVersion((boolean)false);
        if (version != null) {
            String capellaCurrentVersion = version.substring(0, 5);
            int currentRelease = this.getReleaseVersion(capellaCurrentVersion);
            int currentMajorVersion = this.getMajorVersion(capellaCurrentVersion);
            if (fileToMigrateRelease != currentRelease) {
                String formattedMessage = NLS.bind((String)Messages.Error_needMigrationMessage, (Object[])new String[]{modeller.getFullPath().toString()});
                throw new CommandLineException(formattedMessage);
            }
            if (currentMajorVersion != fileToMigrateMajorVersion) {
                String formattedMessage = NLS.bind((String)Messages.Error_needMigrationMessage, (Object[])new String[]{modeller.getFullPath().toString()});
                throw new CommandLineException(formattedMessage);
            }
        } else {
            String formattedMessage = NLS.bind((String)Messages.Error_CorruptedMessage, (Object[])new String[]{modeller.getFullPath().toString()});
            throw new CommandLineException(formattedMessage);
        }
    }

    protected int getMajorVersion(String version) {
        return Integer.parseInt("" + version.charAt(2));
    }

    protected int getMinorVersion(String version) {
        return Integer.parseInt("" + version.charAt(4));
    }

    protected int getReleaseVersion(String version) {
        return Integer.parseInt("" + version.charAt(0));
    }

    private List<IFile> getCapellamodellerFiles(IProject project) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (CapellaResourceHelper.isCapellaResource((IResource)res, (boolean)false)) {
                    files.add((IFile)res);
                }
                ++n2;
            }
        }
        catch (CoreException exception) {
            StringBuilder loggerMessage = new StringBuilder(Messages.compliance_check_pb);
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
        }
        return files;
    }

    @Override
    public boolean execute(IApplicationContext context) throws CommandLineException {
        return false;
    }

    protected void logErrorAndThrowException(String message) throws CommandLineException {
        this.logError(message);
        throw new CommandLineException(message);
    }

    protected boolean isEmtyOrNull(String var) {
        return var == null || var.isEmpty();
    }

    private void checkoutputFolder() throws CommandLineException {
        Path path = new Path(argHelper.getOutputFolder());
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
        if (!folder.exists()) {
            String message = "folder " + argHelper.getOutputFolder() + Messages.not_exist;
            this.logError(message);
            throw new CommandLineException(message);
        }
    }

    private void checkFilePath() throws CommandLineException {
        String projectName = AbstractCommandLine.getProjectName(argHelper.getFilePath());
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            this.logError(String.valueOf(Messages.project) + projectName + Messages.not_exist);
        }
        try {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exception) {
            StringBuilder loggerMessage = new StringBuilder(String.valueOf(Messages.unable_open_project) + project.getName());
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
        }
        IFile file = project.getFile(AbstractCommandLine.getRelativeFilePath(argHelper.getFilePath()));
        if (!file.exists()) {
            String message = String.valueOf(Messages.aird) + argHelper.getFilePath() + Messages.not_exist;
            this.logError(message);
            throw new CommandLineException(message);
        }
    }

    protected void logStatus(IStatus status) {
        if (status.isOK()) {
            __logger.info((Object)status.getMessage());
        } else if (FATAL == status.getSeverity()) {
            __logger.fatal((Object)status.getMessage());
        } else if (4 == status.getSeverity()) {
            __logger.error((Object)status.getMessage());
        } else if (2 == status.getSeverity()) {
            __logger.warn((Object)status.getMessage());
        } else {
            __logger.info((Object)status.getMessage());
        }
        if (status.isMultiStatus()) {
            MultiStatus mStatus = (MultiStatus)status;
            IStatus[] iStatusArray = mStatus.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                this.logStatus(childStatus);
                ++n2;
            }
        }
    }

    protected void logError(String message) {
        StringBuilder loggerMessage = new StringBuilder(message);
        __logger.error((Object)loggerMessage.toString());
    }

    protected void logInfo(String message) {
        StringBuilder loggerMessage = new StringBuilder(message);
        __logger.info((Object)loggerMessage.toString());
    }

    @Deprecated
    protected void LogInfo(String message) {
        this.logInfo(message);
    }

    public void setMode(CommandLineMode mode) {
        this.mode = mode;
    }

    private List<String> toList(String string) {
        ArrayList<String> list = new ArrayList<String>();
        for (String path : Arrays.asList(string.split("\\|"))) {
            list.add(path.trim());
        }
        return list;
    }

    private void importProjects(List<String> projectsToImport) throws CoreException {
        for (String projectPath : projectsToImport) {
            IProject project = null;
            if (projectPath.endsWith(".zip")) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(projectPath));
                WorkbenchHelper.importZipFile(file);
                continue;
            }
            IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription(new Path(projectPath).append(".project"));
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
            if (!project.exists()) {
                project.create(description, null);
            } else {
                project.delete(8, (IProgressMonitor)new NullProgressMonitor());
                project.create(description, null);
                project.open(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            this.importedProjects.add(project.getName());
        }
    }

    private void createOutputFolder(String outputFolder) throws CommandLineException {
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(outputFolder));
        try {
            IProject project = folder.getProject();
            if (!project.exists()) {
                project.create((IProgressMonitor)new NullProgressMonitor());
            }
            if (!project.isOpen()) {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            if (!folder.exists()) {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                this.logInfo(String.valueOf(outputFolder) + Messages.already_exist);
            }
        }
        catch (CoreException exception) {
            StringBuilder message = new StringBuilder(Messages.cannot_create_folder);
            __logger.error((Object)message.toString(), (Throwable)exception);
            throw new CommandLineException(message.toString());
        }
    }

    @Override
    public void printHelp() {
        System.out.println("*** Capella Command Line Core Mechanism ***");
        System.out.println("-appid value : defines the id of the command line application to launch, see org.polarsys.capella.core.commandline.core.commandline extension point.");
        System.out.println("-data value : defines the path to the workspace.");
        System.out.println("-import value : defines a list of projects to import into the workspace before doing the actual job. List of projects is a '|' separated list.");
        System.out.println("-filepath value : defines the path to your aird file.");
        System.out.println("-outputfolder value : defines the path to the output folder.");
        System.out.println("-forceoutputfoldercreation value : create the output folder if it does not exist.");
        System.out.println("-logfile value : defines the path to the log file.");
        System.out.println("-help : prints the help message");
    }

    public static String getProjectName(String filePath) {
        URI fileURI = URI.createFileURI((String)filePath);
        return URI.decode((String)fileURI.segment(0));
    }

    public static String getRelativeFilePath(String filePath) {
        URI fileURI = URI.createFileURI((String)filePath);
        ArrayList<String> segments = new ArrayList<String>(Arrays.asList(fileURI.segments()));
        segments.remove(0);
        if (segments.isEmpty()) {
            return "";
        }
        URI uri = URI.createFileURI((String)((String)segments.get(0)));
        int i = 1;
        while (i < segments.size()) {
            uri = uri.appendSegment((String)segments.get(i));
            ++i;
        }
        return uri.toFileString();
    }

    public List<String> getImportedProjects() {
        return this.importedProjects;
    }
}

