/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commandline.core;

import java.util.Map;
import org.eclipse.equinox.app.IApplicationContext;

public class CommandLineArgumentHelper {
    private static CommandLineArgumentHelper _instance;
    private String filePath;
    private String outputFolder;
    private boolean helpNeeded;
    private String logFilePath;
    private String appid;
    private String importProjects;
    private boolean copyOnWorkspace = false;
    private boolean createFolder;
    private String exportProject;
    private String zipNameProject;
    protected static String[] args;

    public static CommandLineArgumentHelper getInstance() {
        if (_instance == null) {
            _instance = new CommandLineArgumentHelper();
        }
        return _instance;
    }

    public static String[] parseContext(IApplicationContext context_p) {
        Map arguments = context_p.getArguments();
        args = (String[])arguments.get("application.args");
        return args;
    }

    public void parseArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i].toLowerCase();
            if ("-help".equalsIgnoreCase(arg)) {
                this.helpNeeded = true;
            } else if ("-appid".equalsIgnoreCase(arg)) {
                this.appid = args[++i];
            } else if ("-import".equalsIgnoreCase(arg)) {
                this.importProjects = args[++i];
            } else if ("-export".equalsIgnoreCase(arg)) {
                this.exportProject = args[++i];
            } else if ("-exportZipName".equalsIgnoreCase(arg)) {
                this.zipNameProject = args[++i];
            } else if ("-filepath".equalsIgnoreCase(arg)) {
                this.filePath = args[++i];
            } else if ("-outputfolder".equalsIgnoreCase(arg)) {
                this.outputFolder = args[++i];
            } else if ("-forceoutputfoldercreation".equalsIgnoreCase(arg)) {
                this.createFolder = true;
            } else if ("-logfile".equalsIgnoreCase(arg)) {
                this.logFilePath = args[++i];
            } else if ("-copyOnWorkspace".equalsIgnoreCase(arg)) {
                this.copyOnWorkspace = true;
            }
            ++i;
        }
    }

    public static String[] getArgs() {
        return args;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public boolean isHelpNeeded() {
        return this.helpNeeded;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getImportProjects() {
        return this.importProjects;
    }

    public boolean isCreateFolder() {
        return this.createFolder;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public boolean isCopyOnWorkspace() {
        return this.copyOnWorkspace;
    }

    public String getExportProject() {
        return this.exportProject;
    }

    public String getZipNameProject() {
        return this.zipNameProject;
    }
}

