/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commandline.core;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class WorkbenchHelper {
    public static void exportZipFile(IResource resource, IFile theZipFile) {
        try {
            FileOutputStream fos = new FileOutputStream(theZipFile.getLocation().toOSString());
            final ZipOutputStream zos = new ZipOutputStream(fos);
            IResourceVisitor visitor = new IResourceVisitor(){

                public boolean visit(IResource resource_p) throws CoreException {
                    byte[] buffer = new byte[1024];
                    try {
                        if (resource_p instanceof IFile) {
                            int len;
                            ZipEntry ze = new ZipEntry(resource_p.getFullPath().toString().substring(1));
                            zos.putNextEntry(ze);
                            FileInputStream in = new FileInputStream(resource_p.getLocation().toOSString());
                            while ((len = in.read(buffer)) > 0) {
                                zos.write(buffer, 0, len);
                            }
                            in.close();
                            zos.closeEntry();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return true;
                }
            };
            try {
                resource.accept(visitor);
            }
            finally {
                zos.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Collection<IProject> importZipFile(IFile theZipFile) {
        try {
            ZipEntry entry;
            ZipFile zipFile = new ZipFile(theZipFile.getFullPath().toOSString());
            IOverwriteQuery overwriteQuery = new IOverwriteQuery(){

                public String queryOverwrite(String file) {
                    return "ALL";
                }
            };
            ZipLeveledStructureProvider provider = new ZipLeveledStructureProvider(zipFile){

                public List getChildren(Object element_p) {
                    List parrent = super.getChildren(element_p);
                    if (parrent == null) {
                        return Collections.emptyList();
                    }
                    return parrent;
                }
            };
            ArrayList<IProject> projects = new ArrayList<IProject>();
            ArrayList fileSystemObjects = new ArrayList();
            HashMap maps = new HashMap();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (!entry.getName().endsWith(".project")) continue;
                IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription(zipFile.getInputStream(entry));
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
                maps.put(project.getName(), new ArrayList());
                if (!project.exists()) {
                    project.create(null);
                }
                if (project.isOpen()) continue;
                project.open(null);
            }
            entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                if (maps.size() == 1) {
                    ((ArrayList)maps.get(maps.keySet().iterator().next())).add(entry);
                    continue;
                }
                for (String map : maps.keySet()) {
                    if (!entry.getName().startsWith(map)) continue;
                    ((ArrayList)maps.get(map)).add(entry);
                }
            }
            for (String map : maps.keySet()) {
                List files = (List)maps.get(map);
                ImportOperation importOperation = new ImportOperation(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), (Object)new ZipEntry(map), (IImportStructureProvider)provider, overwriteQuery, files);
                importOperation.setCreateContainerStructure(true);
                importOperation.run((IProgressMonitor)new NullProgressMonitor());
                projects.add(ResourcesPlugin.getWorkspace().getRoot().getProject(map));
            }
            return projects;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Collections.emptyList();
        }
    }
}

