/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.ui.quickfix.resolver;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.validation.interface_.ExchangeItemAllocationProtocol;
import org.polarsys.capella.core.data.helpers.information.services.LinkCompatibilityDefinition;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class DWF_I_21_Resolver
extends AbstractCapellaMarkerResolution {
    CommunicationLinkProtocol protocol;
    boolean isSender;

    public DWF_I_21_Resolver(CommunicationLinkProtocol protocol, boolean isSender) {
        this.setLabel(NLS.bind((String)"Set {0} protocol to {1}", (Object)(isSender ? "transmission" : "acquisition"), (Object)protocol));
        this.protocol = protocol;
        this.isSender = isSender;
    }

    protected boolean canResolve(IMarker marker) {
        List objects = MarkerViewHelper.getModelElementsFromMarker((IMarker)marker);
        if (objects.size() > 0 && objects.get(0) instanceof ExchangeItemAllocation) {
            ExchangeItemAllocation allocation = (ExchangeItemAllocation)objects.get(0);
            Diagnostic diagnostic = (Diagnostic)marker.getAdapter(Diagnostic.class);
            if (diagnostic instanceof ConstraintStatusDiagnostic) {
                if (this.isSender && ExchangeItemAllocationProtocol.isSenderAllocation((IStatus)((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus())) {
                    return LinkCompatibilityDefinition.INSTANCE.getCompatibleSendProtocols(allocation).contains(this.protocol);
                }
                if (!this.isSender && ExchangeItemAllocationProtocol.isReceiverAllocation((IStatus)((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus())) {
                    return LinkCompatibilityDefinition.INSTANCE.getCompatibleReceiveProtocols(allocation).contains(this.protocol);
                }
            }
        }
        return false;
    }

    public void run(IMarker marker) {
        final List modelElements = this.getModelElements(marker);
        if (modelElements.isEmpty()) {
            return;
        }
        AbstractReadWriteCommand abstrctCommand = new AbstractReadWriteCommand(){

            public String getName() {
                return DWF_I_21_Resolver.this.getLabel();
            }

            public void run() {
                for (EObject object : modelElements) {
                    if (!(object instanceof ExchangeItemAllocation)) continue;
                    if (DWF_I_21_Resolver.this.isSender) {
                        ((ExchangeItemAllocation)object).setSendProtocol(DWF_I_21_Resolver.this.protocol);
                        continue;
                    }
                    ((ExchangeItemAllocation)object).setReceiveProtocol(DWF_I_21_Resolver.this.protocol);
                }
            }
        };
        TransactionHelper.getExecutionManager((Collection)modelElements).execute((ICommand)abstrctCommand);
        try {
            marker.delete();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return super.findOtherMarkers(markers);
    }

    protected String[] getResolvableRuleIds() {
        return new String[]{"DWF_I_21"};
    }

    protected boolean quickFixAllSimilarEnabled(Collection<IMarker> markers) {
        return true;
    }
}

