/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.patterns.migration;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.diffmerge.patterns.repositories.catalogs.PatternCatalogResourceHelper;
import org.eclipse.emf.diffmerge.patterns.support.gen.commonpatternsupport.CommonpatternsupportFactory;
import org.eclipse.emf.diffmerge.patterns.support.gen.commonpatternsupport.CommonpatternsupportPackage;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.core.data.migration.MigrationHelpers;
import org.polarsys.capella.core.data.migration.handlers.AbstractMigrationHandler;
import org.polarsys.capella.patterns.migration.PatternsMigrationConstants;
import org.polarsys.kitalpha.patterns.emde.gen.emdepatternsupport.EmdepatternsupportFactory;
import org.polarsys.kitalpha.patterns.emde.gen.emdepatternsupport.EmdepatternsupportPackage;

public class PatternsCustomizeHandler
extends AbstractMigrationHandler {
    protected String getQualifiedClassName(String prefix, String className_p) {
        return String.valueOf(prefix) + ':' + className_p;
    }

    public EFactory getFactoryForPrefix(String prefix) {
        if (PatternsMigrationConstants.KITALPHA_PATTERN_SUPPORT_GEN_PREFIX.equals(prefix)) {
            EmdepatternsupportFactory f = EmdepatternsupportFactory.eINSTANCE;
            f.setEPackage((EPackage)EmdepatternsupportPackage.eINSTANCE);
            return f;
        }
        if (PatternsMigrationConstants.DEFAULT_PATTERN_SUPPORT_GEN_PREFIX.equals(prefix)) {
            CommonpatternsupportFactory f = CommonpatternsupportFactory.eINSTANCE;
            f.setEPackage((EPackage)CommonpatternsupportPackage.eINSTANCE);
            return f;
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        for (Object selected : selection.toList()) {
            if (!(selected instanceof IResource)) continue;
            MigrationHelpers.getInstance().trigger((IResource)selected, HandlerUtil.getActiveShell((ExecutionEvent)event), false, true, new String[]{"MIGRATION_KIND__PATTERN"});
        }
        return event;
    }

    protected boolean isValidSelection(List<Object> selection) {
        for (Object select : selection) {
            if (select instanceof IFile && PatternCatalogResourceHelper.isPatternCatalogResource((IResource)((IFile)select))) continue;
            return false;
        }
        return true;
    }
}

