/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.patterns.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractPattern;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.CorepatternsPackage;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternRepository;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class PatternsMigrationHelper {
    private static PatternsMigrationHelper __instance = null;
    protected static final String DEFAULT_DESCRIPTION = "";
    protected static final String DEFAULT_VERSION = "1.0";
    protected static final String MAIN_MULTIPART = "MAIN";
    private List<String> _environments = null;

    public static PatternsMigrationHelper getInstance() {
        if (__instance == null) {
            __instance = new PatternsMigrationHelper();
        }
        return __instance;
    }

    protected List<String> computeEnvironments() {
        Version version;
        Bundle mainBundle;
        List<String> result = Collections.emptyList();
        String currentProductLabel = null;
        IProduct product = Platform.getProduct();
        if (product != null && (currentProductLabel = product.getName()) != null && (mainBundle = Platform.getProduct().getDefiningBundle()) != null && (version = mainBundle.getVersion()) != null) {
            currentProductLabel = String.valueOf(currentProductLabel) + ' ' + version.getMajor() + '.' + version.getMinor() + '.' + 'x';
        }
        if (currentProductLabel != null) {
            result = Collections.singletonList(currentProductLabel);
        }
        return result;
    }

    protected List<String> getEnvironments() {
        if (this._environments == null) {
            this._environments = this.computeEnvironments();
        }
        return this._environments;
    }

    public void migrateCatalog(EObject oldCatalog_p) {
        if (oldCatalog_p instanceof PatternRepository) {
            PatternRepository rp = (PatternRepository)oldCatalog_p;
            for (AbstractPattern pat : rp.getPatterns()) {
                this.migratePattern(pat);
            }
        }
    }

    protected void migratePattern(AbstractPattern oldPattern_p) {
        List<String> envs = this.getEnvironments();
        if (envs != null && !envs.isEmpty()) {
            this.setNewExecutionEnvironmentForPattern((EObject)oldPattern_p, envs.get(0));
        }
        for (IPatternRole role : oldPattern_p.getRoles()) {
            this.migratePatternRole(role);
        }
    }

    protected void migratePatternRole(IPatternRole oldRole_p) {
        if (oldRole_p instanceof TemplatePatternRole) {
            TemplatePatternRole role = (TemplatePatternRole)oldRole_p;
            role.setPreferredContainment(null);
        }
    }

    protected void setNewExecutionEnvironmentForPattern(EObject pattern_p, String environment_p) {
        ArrayList<String> newExecutionEnv = new ArrayList<String>();
        newExecutionEnv.add(environment_p);
        if (pattern_p != null) {
            String EXECUTION_ENVIRONMENTS = CorepatternsPackage.eINSTANCE.getAbstractPattern_ExecutionEnvironments().getName();
            EStructuralFeature patternEnvironment = pattern_p.eClass().getEStructuralFeature(EXECUTION_ENVIRONMENTS);
            if (patternEnvironment != null) {
                pattern_p.eSet(patternEnvironment, newExecutionEnv);
            }
        }
    }
}

