/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.transformation.emf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IDomainHelper;
import org.polarsys.kitalpha.transposer.transformation.emf.TransposerEMFPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfDomainHelper
implements IDomainHelper {
    public Collection<Class<?>> getAllDomainMetaclasses() {
        LinkedHashSet classes = new LinkedHashSet();
        Set<EClass> allEClasses = this.getAllEClasses();
        for (EClass eClass : allEClasses) {
            Class instanceClass = eClass.getInstanceClass();
            if (instanceClass == null) continue;
            classes.add(instanceClass);
        }
        return classes;
    }

    protected Set<EClass> getAllEClasses() {
        LinkedHashSet<EClass> allEClasses = new LinkedHashSet<EClass>();
        for (EPackage ePackage : this.getEPackages()) {
            this.addEClasses(ePackage, allEClasses);
        }
        return allEClasses;
    }

    private void addEClasses(EPackage package_p, Set<EClass> accumulator_p) {
        for (EClassifier eClassifier : package_p.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            accumulator_p.add((EClass)eClassifier);
        }
        for (EPackage eSubPackage : package_p.getESubpackages()) {
            this.addEClasses(eSubPackage, accumulator_p);
        }
    }

    protected Set<EPackage> getEPackages() {
        LinkedHashSet<EPackage> eAllPackages = new LinkedHashSet<EPackage>();
        eAllPackages.add((EPackage)EcorePackage.eINSTANCE);
        return eAllPackages;
    }

    public Collection<Object> getAnalysisSources(Collection<?> selection_p) {
        ArrayList<Object> eObjectsToAnalyse = new ArrayList<Object>();
        for (Object obj : selection_p) {
            if (!(obj instanceof EObject)) continue;
            eObjectsToAnalyse.add(obj);
        }
        return eObjectsToAnalyse;
    }

    public Class<?> getDomainMetaclass(String name_p) {
        try {
            return Class.forName(name_p);
        }
        catch (ClassNotFoundException e) {
            TransposerEMFPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.transposer.transformation.emf", "No Domain Class called : " + name_p, (Throwable)e));
            return null;
        }
    }

    public Class<?> getDomainMetaclass(Object object_p) {
        if (object_p instanceof EObject) {
            return ((EObject)object_p).eClass().getInstanceClass();
        }
        return null;
    }

    public String getName(Object modelElement_p) {
        if (modelElement_p instanceof ENamedElement) {
            return ((ENamedElement)modelElement_p).getName();
        }
        return "";
    }

    public boolean isDomainFor(Object object_p) {
        return object_p instanceof EObject;
    }

    public boolean isHotSpot(Object object_p) {
        return object_p instanceof EClass;
    }
}

