/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.lib;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class NameHelper {
    private static final String BUSINESS_INFORMATION_SOURCE = "http://www.polarsys.org/capella/2007/BusinessInformation";
    private static final String NAMING_ATTRIBUTE_KEY = "namingAttribute";

    public static void setUniqueString(EObject object, EObject container, EAttribute attribute, String defaultString, String pattern) {
        int counter = 0;
        EList siblings = container.eContents();
        if (siblings != null && !siblings.isEmpty()) {
            ArrayList<String> existingNames = new ArrayList<String>();
            if (attribute != null) {
                for (Object sibling : siblings) {
                    String name;
                    EObject eSibling = (EObject)sibling;
                    Object attributeValue = eSibling.eGet((EStructuralFeature)attribute);
                    if (!(attributeValue instanceof String) || (name = (String)attributeValue) == null || name.equals("")) continue;
                    existingNames.add(name);
                }
                String copiedEObjectName = defaultString;
                while (existingNames.contains(copiedEObjectName)) {
                    copiedEObjectName = MessageFormat.format(pattern, counter++, defaultString);
                }
                object.eSet((EStructuralFeature)attribute, (Object)copiedEObjectName);
            }
        }
    }

    public static EAttribute getNamingAttribute(EObject eObject) {
        for (EAttribute eAttribute : eObject.eClass().getEAllAttributes()) {
            EAnnotation businessAnnotation = eAttribute.getEAnnotation(BUSINESS_INFORMATION_SOURCE);
            if (businessAnnotation == null || !businessAnnotation.getDetails().containsKey((Object)NAMING_ATTRIBUTE_KEY)) continue;
            return eAttribute;
        }
        return null;
    }
}

