/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.consonance.ui.sirius;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.gmf.GMFDiffPolicy;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.sequence.ordering.OrderingPackage;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class SiriusDiffPolicy
extends GMFDiffPolicy {
    private static final char SEGMENT_SEPARATOR = '/';
    private static final Collection<EReference> SEMANTICALLY_UNORDERED_REFERENCES = Arrays.asList(DiagramPackage.eINSTANCE.getDDiagram_ActivatedLayers(), DiagramPackage.eINSTANCE.getDDiagram_OwnedDiagramElements(), ViewpointPackage.eINSTANCE.getDAnalysis_Models(), ViewpointPackage.eINSTANCE.getDAnalysis_OwnedViews(), ViewpointPackage.eINSTANCE.getDRepresentationElement_SemanticElements(), DiagramPackage.eINSTANCE.getEdgeTarget_IncomingEdges(), DiagramPackage.eINSTANCE.getEdgeTarget_OutgoingEdges());
    private static final Collection<EReference> UNSIGNIFICANT_REFERENCES = Arrays.asList(ViewpointPackage.eINSTANCE.getDRepresentation_UiState(), DiagramPackage.eINSTANCE.getDDiagram_HiddenElements());
    private static final Collection<EClass> UNSIGNIFICANT_TYPES = Arrays.asList(OrderingPackage.eINSTANCE.getEventEndsOrdering(), OrderingPackage.eINSTANCE.getInstanceRolesOrdering(), ViewpointPackage.eINSTANCE.getUIState());
    private static final Collection<EAttribute> IGNORING_EMPTY_STRING_ATTRIBUTES = Arrays.asList(DiagramPackage.eINSTANCE.getDDiagramElement_TooltipText());

    public boolean coverFeature(EStructuralFeature feature) {
        return !UNSIGNIFICANT_REFERENCES.contains(feature) && super.coverFeature(feature);
    }

    public boolean coverMatch(IMatch match) {
        EObject element;
        boolean result = super.coverMatch(match);
        if (result && match.isPartial() && (element = match.get(match.getUncoveredRole().opposite())) != null) {
            result = !UNSIGNIFICANT_TYPES.contains(element.eClass());
        }
        return result;
    }

    public boolean coverValue(Object value, EAttribute attribute) {
        boolean result = IGNORING_EMPTY_STRING_ATTRIBUTES.contains(attribute) && ((String)value).length() == 0 ? false : super.coverValue(value, attribute);
        return result;
    }

    protected boolean doConsiderOrdered(EStructuralFeature feature) {
        return super.doConsiderOrdered(feature) && !SEMANTICALLY_UNORDERED_REFERENCES.contains(feature);
    }

    public boolean considerEqual(Object value1, Object value2, EAttribute attribute) {
        boolean result = super.considerEqual(value1, value2, attribute);
        if (!result && ViewpointPackage.eINSTANCE.getDAnalysis_SemanticResources() == attribute) {
            URI refURI = ((ResourceDescriptor)value1).getResourceURI();
            URI trgtURI = ((ResourceDescriptor)value2).getResourceURI();
            int positionInRefURI = this.getProjectPositionInURI(refURI);
            int positionInTrgtURI = this.getProjectPositionInURI(trgtURI);
            String refURIStr = positionInRefURI != -1 ? this.makeRelativeToProject(refURI, positionInRefURI) : refURI.toString();
            String trgtURIStr = positionInTrgtURI != -1 ? this.makeRelativeToProject(trgtURI, positionInTrgtURI) : trgtURI.toString();
            return refURIStr.equals(trgtURIStr);
        }
        return result;
    }

    protected String makeRelativeToProject(URI uri, int projectPositionInURI) {
        StringBuilder result = new StringBuilder();
        int i = projectPositionInURI;
        while (i < uri.segments().length) {
            result.append('/');
            result.append(uri.segment(i));
            ++i;
        }
        return result.toString();
    }

    protected int getProjectPositionInURI(URI uri) {
        if (uri.isPlatformResource()) {
            return 2;
        }
        return -1;
    }
}

