/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.consonance.ui.sirius;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.gmf.GMFScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;
import org.polarsys.capella.common.consonance.ui.sirius.SiriusScopeFactory;

public class SiriusScope
extends GMFScope {
    protected static final Collection<? extends EPackage> VIEWPOINT_PACKAGES = Arrays.asList(ViewpointPackage.eINSTANCE, StylePackage.eINSTANCE, NotationPackage.eINSTANCE, DiagramPackage.eINSTANCE);

    public SiriusScope(URI uri, EditingDomain domain, boolean readOnly) {
        super(uri, domain, readOnly);
    }

    public SiriusScope(URI uri, ResourceSet resourceSet, boolean readOnly) {
        super(uri, resourceSet, readOnly);
    }

    protected Collection<EReference> getCrossReferencesInScope(EObject element) {
        Collection result = super.getCrossReferencesInScope(element);
        if (element instanceof DSemanticDecorator) {
            result.add(ViewpointPackage.eINSTANCE.getDSemanticDecorator_Target());
        } else if (element instanceof DAnalysis) {
            result.add(ViewpointPackage.eINSTANCE.getDAnalysis_ReferencedAnalysis());
            result.add(ViewpointPackage.eINSTANCE.getDAnalysis_Models());
        }
        return result;
    }

    protected boolean isSuitableFor(Resource resource, EObject root) {
        boolean result = this.isViewpointResource(resource) == this.isViewpointElement(root);
        return result;
    }

    protected boolean isViewpointElement(EObject element) {
        EPackage pack = element.eClass().getEPackage();
        return VIEWPOINT_PACKAGES.contains(pack) || element instanceof DRepresentation;
    }

    protected boolean isViewpointResource(Resource resource) {
        String extension;
        boolean result = false;
        if (resource.getURI() != null && (extension = resource.getURI().fileExtension()) != null) {
            extension = extension.toLowerCase();
            result = SiriusScopeFactory.VIEWPOINT_FILE_EXTENSIONS.contains(extension);
        }
        return result;
    }
}

