/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.linkedtext.ui;

import com.google.common.base.Predicate;
import java.util.Collection;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.linkedtext.ui.DefaultLinkedTextContentProvider;
import org.polarsys.capella.common.linkedtext.ui.EmbeddedLinkedTextEditor;
import org.polarsys.capella.common.linkedtext.ui.EmbeddedLinkedTextEditorConfiguration;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextHyperlink;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextHyperlinkDetector;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.libraries.model.ICapellaModel;

public class CapellaEmbeddedLinkedTextEditor
extends EmbeddedLinkedTextEditor {
    static final IHyperlinkDetector[] _hyperlinkDetectors = new IHyperlinkDetector[]{new LinkedTextHyperlinkDetector(){

        protected void appendLinksFor(final LinkedTextHyperlink hl_p, Collection<IHyperlink> links_p) {
            links_p.add(new IHyperlink(){
                final IRegion region;
                {
                    this.region = new Region(linkedTextHyperlink.getOffset(), linkedTextHyperlink.getLength());
                }

                public void open() {
                    IViewPart part;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (part = window.getActivePage().findView("capella.project.explorer")) != null) {
                        IShowInTarget showInTarget = (IShowInTarget)part.getAdapter(IShowInTarget.class);
                        showInTarget.show(new ShowInContext(null, (ISelection)new StructuredSelection(hl_p.getTarget())));
                    }
                }

                public String getTypeLabel() {
                    return "";
                }

                public String getHyperlinkText() {
                    return "";
                }

                public IRegion getHyperlinkRegion() {
                    return this.region;
                }
            });
        }
    }};

    public CapellaEmbeddedLinkedTextEditor(Composite parent_p, int style_p) {
        super(parent_p, style_p);
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        return new EmbeddedLinkedTextEditorConfiguration(){

            public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer_p) {
                return _hyperlinkDetectors;
            }

            protected IStructuredContentProvider getCompletionProcessorContentProvider() {
                return new DefaultLinkedTextContentProvider((Predicate)new Predicate<EObject>(){

                    public boolean apply(EObject arg0_p) {
                        return arg0_p instanceof AbstractNamedElement;
                    }
                }){

                    protected void fillAdditionalElements(EObject inputElement_p, Collection<EObject> result_p) {
                        IModel model = ILibraryManager.INSTANCE.getModel(inputElement_p);
                        for (IModel lib : LibraryManagerExt.getAllActivesReferences((IModel)model)) {
                            if (!(lib instanceof ICapellaModel)) continue;
                            Project root = ((ICapellaModel)lib).getProject(TransactionUtil.getEditingDomain((EObject)inputElement_p));
                            TreeIterator contents = root.eAllContents();
                            while (contents.hasNext()) {
                                EObject next = (EObject)contents.next();
                                if (!this.getEObjectPredicate().apply((Object)next)) continue;
                                result_p.add(next);
                            }
                        }
                    }
                };
            }
        };
    }
}

