/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.helpers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.helpers.CommonStructureHelper;

public class SAStructureHelper {
    public static OperationalAnalysis getOperationalAnalysis(SystemEngineering systemEngineering_p) {
        if (systemEngineering_p != null) {
            for (ModellingArchitecture arch : systemEngineering_p.getOwnedArchitectures()) {
                if (!(arch instanceof OperationalAnalysis)) continue;
                return (OperationalAnalysis)arch;
            }
        }
        return null;
    }

    public static OperationalActivity getRootOperationalActivity(SystemEngineering systemEngineering_p) {
        OperationalActivityPkg activityPkg;
        OperationalAnalysis operationalAnalysis = SAStructureHelper.getOperationalAnalysis(systemEngineering_p);
        if (operationalAnalysis != null && (activityPkg = (OperationalActivityPkg)operationalAnalysis.getOwnedFunctionPkg()) != null && !activityPkg.getOwnedOperationalActivities().isEmpty()) {
            return (OperationalActivity)activityPkg.getOwnedOperationalActivities().get(0);
        }
        return null;
    }

    public static Command getSystemAnalysisCreationCmd(final EditingDomain editingDomain_p, final SystemEngineering systemEngineering_p) {
        CompoundCommand cmd = new CompoundCommand();
        final Command createSystemAnalysisCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)systemEngineering_p, (Object)new CommandParameter((Object)systemEngineering_p, (Object)CapellacorePackage.Literals.ABSTRACT_MODELLING_STRUCTURE__OWNED_ARCHITECTURES, (Object)CtxFactory.eINSTANCE.createSystemAnalysis(NamingConstants.CreateSysAnalysisCmd_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createSystemAnalysisCmd);
        CommandWrapper createSystemAnalysisContentCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdSystemAnalysis;
                Collection res = createSystemAnalysisCmd.getResult();
                if (res.size() == 1 && (createdSystemAnalysis = res.iterator().next()) instanceof SystemAnalysis) {
                    return SAStructureHelper.getSystemAnalysisCreationCmd(editingDomain_p, systemEngineering_p, (SystemAnalysis)createdSystemAnalysis);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createSystemAnalysisContentCmd);
        return cmd;
    }

    public static Command getSystemAnalysisCreationCmd(EditingDomain editingDomain_p, SystemEngineering systemEngineering_p, SystemAnalysis systemAnalysis_p) {
        CompoundCommand cmd = new CompoundCommand();
        OperationalAnalysis operationalAnalysis = SAStructureHelper.getOperationalAnalysis(systemEngineering_p);
        cmd.append(CommonStructureHelper.getLinkCreationCmd(editingDomain_p, CtxPackage.Literals.OPERATIONAL_ANALYSIS_REALIZATION, CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_OPERATIONAL_ANALYSIS_REALIZATIONS, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, (EObject)systemAnalysis_p, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, (EObject)operationalAnalysis));
        cmd.append(CommonStructureHelper.getRequirementPkgCreationCmd(editingDomain_p, (BlockArchitecture)systemAnalysis_p));
        cmd.append(SAStructureHelper.getSystemFunctionPkgCreationCmd(editingDomain_p, systemEngineering_p, systemAnalysis_p));
        cmd.append(SAStructureHelper.getCapabilityPkgCreationCmd(editingDomain_p, systemAnalysis_p));
        cmd.append(SAStructureHelper.getMissionPkgCreationCmd(editingDomain_p, systemAnalysis_p));
        cmd.append(CommonStructureHelper.getInterfacePkgCreationCmd(editingDomain_p, (BlockArchitecture)systemAnalysis_p));
        cmd.append(CommonStructureHelper.getDataPkgCreationCmd(editingDomain_p, (BlockArchitecture)systemAnalysis_p, true));
        cmd.append(SAStructureHelper.getActorPkgCreationCmd(editingDomain_p, systemAnalysis_p));
        cmd.append(SAStructureHelper.getSystemCreationCmd(editingDomain_p, systemAnalysis_p));
        return cmd;
    }

    public static Command getSystemCreationCmd(final EditingDomain editingDomain_p, SystemAnalysis systemAnalysis_p) {
        CompoundCommand cmd = new CompoundCommand();
        final Command createSystemContextCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)systemAnalysis_p, (Object)new CommandParameter((Object)systemAnalysis_p, (Object)CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_SYSTEM_CONTEXT, (Object)CtxFactory.eINSTANCE.createSystemContext(NamingConstants.CreateSysAnalysisCmd_system_context_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createSystemContextCmd);
        final Command createSystemCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)systemAnalysis_p, (Object)new CommandParameter((Object)systemAnalysis_p, (Object)CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_SYSTEM, (Object)CtxFactory.eINSTANCE.createSystem(NamingConstants.CreateSysAnalysisCmd_system_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createSystemCmd);
        CommandWrapper createPartCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdContext;
                Collection res = createSystemContextCmd.getResult();
                if (res.size() == 1 && (createdContext = res.iterator().next()) instanceof EObject) {
                    return CreateChildCommand.create((EditingDomain)editingDomain_p, createdContext, (Object)new CommandParameter(createdContext, (Object)CapellacorePackage.Literals.CLASSIFIER__OWNED_FEATURES, (Object)CsFactory.eINSTANCE.createPart()), (Collection)Collections.EMPTY_LIST);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createPartCmd);
        CommandWrapper setPartNameCmd = new CommandWrapper((Command)createPartCmd, createSystemCmd, editingDomain_p){
            private final /* synthetic */ Command val$createPartCmd;
            private final /* synthetic */ Command val$createSystemCmd;
            private final /* synthetic */ EditingDomain val$editingDomain_p;
            {
                this.val$createPartCmd = command;
                this.val$createSystemCmd = command2;
                this.val$editingDomain_p = editingDomain;
            }

            public Command createCommand() {
                Collection res1 = this.val$createPartCmd.getResult();
                Collection res2 = this.val$createSystemCmd.getResult();
                if (res1.size() == 1 && res2.size() == 1) {
                    Object createdPart = res1.iterator().next();
                    Object createdSystem = res2.iterator().next();
                    if (createdPart instanceof EObject && createdSystem instanceof EObject) {
                        return new SetCommand(this.val$editingDomain_p, (EObject)createdPart, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (Object)((AbstractNamedElement)createdSystem).getName());
                    }
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)setPartNameCmd);
        CommandWrapper setPartTypeCmd = new CommandWrapper((Command)createPartCmd, createSystemCmd, editingDomain_p){
            private final /* synthetic */ Command val$createPartCmd;
            private final /* synthetic */ Command val$createSystemCmd;
            private final /* synthetic */ EditingDomain val$editingDomain_p;
            {
                this.val$createPartCmd = command;
                this.val$createSystemCmd = command2;
                this.val$editingDomain_p = editingDomain;
            }

            public Command createCommand() {
                Collection res1 = this.val$createPartCmd.getResult();
                Collection res2 = this.val$createSystemCmd.getResult();
                if (res1.size() == 1 && res2.size() == 1) {
                    Object createdPart = res1.iterator().next();
                    Object createdSystem = res2.iterator().next();
                    if (createdPart instanceof EObject && createdSystem instanceof EObject) {
                        return new SetCommand(this.val$editingDomain_p, (EObject)createdPart, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE, createdSystem);
                    }
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)setPartTypeCmd);
        CommandWrapper createStateMachineCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdSystem;
                Collection res = createSystemCmd.getResult();
                if (res.size() == 1 && (createdSystem = res.iterator().next()) instanceof EObject) {
                    return CreateChildCommand.create((EditingDomain)editingDomain_p, createdSystem, (Object)new CommandParameter(createdSystem, (Object)CsPackage.Literals.BLOCK__OWNED_STATE_MACHINES, (Object)CapellacommonFactory.eINSTANCE.createStateMachine(NamingConstants.CreateSysAnalysisCmd_system_statemachine_name)), (Collection)Collections.EMPTY_LIST);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createStateMachineCmd);
        CommandWrapper createRegionCmd = new CommandWrapper((Command)createStateMachineCmd, editingDomain_p){
            private final /* synthetic */ Command val$createStateMachineCmd;
            private final /* synthetic */ EditingDomain val$editingDomain_p;
            {
                this.val$createStateMachineCmd = command;
                this.val$editingDomain_p = editingDomain;
            }

            public Command createCommand() {
                Object createdStateMachine;
                Collection res = this.val$createStateMachineCmd.getResult();
                if (res.size() == 1 && (createdStateMachine = res.iterator().next()) instanceof EObject) {
                    return CreateChildCommand.create((EditingDomain)this.val$editingDomain_p, createdStateMachine, (Object)new CommandParameter(createdStateMachine, (Object)CapellacommonPackage.Literals.STATE_MACHINE__OWNED_REGIONS, (Object)CapellacommonFactory.eINSTANCE.createRegion(NamingConstants.Region_DefaultRegion)), (Collection)Collections.EMPTY_LIST);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createRegionCmd);
        return cmd;
    }

    public static Command getActorPkgCreationCmd(EditingDomain editingDomain_p, SystemAnalysis systemAnalysis_p) {
        return CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)systemAnalysis_p, (Object)new CommandParameter((Object)systemAnalysis_p, (Object)CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_ACTOR_PKG, (Object)CtxFactory.eINSTANCE.createActorPkg(NamingConstants.CreateSysAnalysisCmd_actors_pkg_name)), (Collection)Collections.EMPTY_LIST);
    }

    public static Command getCapabilityPkgCreationCmd(EditingDomain editingDomain_p, SystemAnalysis systemAnalysis_p) {
        return CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)systemAnalysis_p, (Object)new CommandParameter((Object)systemAnalysis_p, (Object)CsPackage.Literals.BLOCK_ARCHITECTURE__OWNED_ABSTRACT_CAPABILITY_PKG, (Object)CtxFactory.eINSTANCE.createCapabilityPkg(NamingConstants.CreateSysAnalysisCmd_capabilities_pkg_name)), (Collection)Collections.EMPTY_LIST);
    }

    public static Command getMissionPkgCreationCmd(EditingDomain editingDomain_p, SystemAnalysis systemAnalysis_p) {
        return CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)systemAnalysis_p, (Object)new CommandParameter((Object)systemAnalysis_p, (Object)CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_MISSION_PKG, (Object)CtxFactory.eINSTANCE.createMissionPkg(NamingConstants.CreateSysAnalysisCmd_missions_pkg_name)), (Collection)Collections.EMPTY_LIST);
    }

    public static Command getSystemFunctionPkgCreationCmd(final EditingDomain editingDomain_p, SystemEngineering systemEngineering_p, SystemAnalysis systemAnalysis_p) {
        CompoundCommand cmd = new CompoundCommand();
        final Command createSystemFunctionPkgCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)systemAnalysis_p, (Object)new CommandParameter((Object)systemAnalysis_p, (Object)FaPackage.Literals.ABSTRACT_FUNCTIONAL_ARCHITECTURE__OWNED_FUNCTION_PKG, (Object)CtxFactory.eINSTANCE.createSystemFunctionPkg(NamingConstants.CreateSysAnalysisCmd_system_functions_pkg_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createSystemFunctionPkgCmd);
        CommandWrapper createSystemFunctionCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdSystemFunctionPkg;
                Collection res = createSystemFunctionPkgCmd.getResult();
                if (res.size() == 1 && (createdSystemFunctionPkg = res.iterator().next()) instanceof EObject) {
                    return CreateChildCommand.create((EditingDomain)editingDomain_p, createdSystemFunctionPkg, (Object)new CommandParameter(createdSystemFunctionPkg, (Object)CtxPackage.Literals.SYSTEM_FUNCTION_PKG__OWNED_SYSTEM_FUNCTIONS, (Object)CtxFactory.eINSTANCE.createSystemFunction(NamingConstants.CreateSysAnalysisCmd_system_function_root_name)), (Collection)Collections.EMPTY_LIST);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createSystemFunctionCmd);
        CommandWrapper createOperationalActivityRealizationCmd = new CommandWrapper((Command)createSystemFunctionCmd, systemEngineering_p, editingDomain_p){
            private final /* synthetic */ Command val$createSystemFunctionCmd;
            private final /* synthetic */ SystemEngineering val$systemEngineering_p;
            private final /* synthetic */ EditingDomain val$editingDomain_p;
            {
                this.val$createSystemFunctionCmd = command;
                this.val$systemEngineering_p = systemEngineering;
                this.val$editingDomain_p = editingDomain;
            }

            public Command createCommand() {
                Object createdSystemFunction;
                Collection res = this.val$createSystemFunctionCmd.getResult();
                if (res.size() == 1 && (createdSystemFunction = res.iterator().next()) instanceof EObject) {
                    OperationalActivity rootOperationalActivity = SAStructureHelper.getRootOperationalActivity(this.val$systemEngineering_p);
                    return CommonStructureHelper.getLinkCreationCmd(this.val$editingDomain_p, FaPackage.Literals.FUNCTION_REALIZATION, FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTION_REALIZATIONS, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, (EObject)createdSystemFunction, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, (EObject)rootOperationalActivity);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createOperationalActivityRealizationCmd);
        return cmd;
    }
}

