/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.impl.cmd;

import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerFactory;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.skeleton.Messages;

public class CreateEngSystemCmd
extends AbstractReadWriteCommand {
    private String _systemEngName;
    private SystemEngineering _systemEng;
    private Project _project;

    public CreateEngSystemCmd(Project project_p, String systemName_p) {
        if (systemName_p == null) {
            throw new IllegalArgumentException("The system engineering name parameter cannot be null !");
        }
        if (project_p == null) {
            throw new IllegalArgumentException("The Capella project parameter cannot be null !");
        }
        this._project = project_p;
        this._systemEngName = systemName_p;
    }

    public void run() {
        this._systemEng = CapellamodellerFactory.eINSTANCE.createSystemEngineering(this._systemEngName);
        this._project.getOwnedModelRoots().add((Object)this._systemEng);
    }

    public String getName() {
        return Messages.getString("capella.sys_eng.create.cmd");
    }

    public SystemEngineering getSystemEngineering() {
        return this._systemEng;
    }
}

