/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.framework.ui.model;

import java.util.ArrayList;
import java.util.List;

public abstract class SelectionItemNode {
    private boolean isChecked = false;
    private SelectionItemNode parent = null;
    private List<SelectionItemNode> children = new ArrayList<SelectionItemNode>();

    public abstract String getName();

    public abstract String getFullName();

    public abstract Object getData();

    public abstract Object getSrc();

    public List<SelectionItemNode> getChildren() {
        return this.children;
    }

    public SelectionItemNode getParent() {
        return this.parent;
    }

    public void setParent(SelectionItemNode parent) {
        this.parent = parent;
    }

    public void setIsChecked(boolean checked) {
        this.isChecked = checked;
    }

    public boolean hasChildrenChecked() {
        boolean result = false;
        for (SelectionItemNode node : this.children) {
            result |= node.isChecked;
        }
        return result;
    }

    public boolean hasAllChildrenChecked() {
        boolean result = true;
        for (SelectionItemNode node : this.children) {
            result &= node.isChecked;
        }
        return result;
    }

    public void addChild(SelectionItemNode node) {
        if (this.children == null) {
            this.children = new ArrayList<SelectionItemNode>();
        }
        this.children.add(node);
        node.setParent(this);
    }

    public String toString() {
        return "Node[" + this.getName() + "," + this.getChildren() + "]";
    }
}

