/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.AbstractDependenciesPkgExt;
import org.polarsys.capella.core.model.helpers.ClassifierExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.LogicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.PhysicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.StructureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.queries.QueryIdentifierConstants;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.ListExt;

public class CollectionExt {
    public static java.util.Collection<Collection> getAllCollections(EObject context) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_COLLECTIONS, (Object)context);
    }

    public static List<EObject> getAllTypes(Collection collection) {
        List<EObject> list = new ArrayList<EObject>();
        if (collection != null) {
            Structure structure = (Structure)collection.eContainer();
            if (structure != null) {
                BlockArchitecture arch = StructureExt.getRootBlockArchitecture(structure);
                if (arch != null) {
                    if (arch instanceof LogicalArchitecture) {
                        list.addAll(DataPkgExt.getAllTypesFromDataPkg(((LogicalArchitecture)arch).getOwnedDataPkg()));
                        list.addAll(LogicalArchitectureExt.getAllInterfacesInLogicalArchitecture((LogicalArchitecture)arch));
                        for (LogicalArchitecture logArch : LogicalArchitectureExt.getAllLogicalArchitectures((LogicalArchitecture)arch)) {
                            list.addAll(DataPkgExt.getAllTypesFromDataPkg(logArch.getOwnedDataPkg()));
                        }
                    } else if (arch instanceof PhysicalArchitecture) {
                        list.addAll(DataPkgExt.getAllTypesFromDataPkg(((PhysicalArchitecture)arch).getOwnedDataPkg()));
                        list.addAll(PhysicalArchitectureExt.getAllInterfaces(arch, null, false));
                    } else if (arch instanceof EPBSArchitecture) {
                        list.addAll(DataPkgExt.getAllTypesFromDataPkg(((EPBSArchitecture)arch).getOwnedDataPkg()));
                    }
                }
                SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)collection);
                SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis(sysEng);
                if (sysEng != null) {
                    list.addAll(DataPkgExt.getAllTypesFromDataPkg(ca.getOwnedDataPkg()));
                    list.addAll(InterfacePkgExt.getAllInterfaces(ca.getOwnedInterfacePkg()));
                }
            }
            list = ListExt.removeDuplicates(list);
        }
        return list;
    }

    public static Map<AbstractDependenciesPkg, java.util.Collection<EObject>> getCollectionDependencies2(Collection collection) {
        HashMap<AbstractDependenciesPkg, java.util.Collection<EObject>> result = new HashMap<AbstractDependenciesPkg, java.util.Collection<EObject>>();
        AbstractDependenciesPkgExt.checkDependenciesAndAddToResult(result, (EObject)collection.getType());
        for (DataType dataType : collection.getIndex()) {
            AbstractDependenciesPkgExt.checkDependenciesAndAddToResult(result, (EObject)dataType);
        }
        for (Generalization aGeneralization : collection.getSuperGeneralizations()) {
            AbstractDependenciesPkgExt.checkDependenciesAndAddToResult(result, (EObject)aGeneralization.getSuper());
        }
        return result;
    }

    public static java.util.Collection<AbstractDependenciesPkg> getCollectionDependencies(Collection collection) {
        return CollectionExt.getCollectionDependencies2(collection).keySet();
    }

    public static DataPkg getDataPkg(Structure structure) {
        DataPkg dataPkg = null;
        if (structure != null) {
            EObject container = structure.eContainer();
            if (container instanceof DataPkg) {
                dataPkg = (DataPkg)container;
            } else if (container instanceof Structure) {
                dataPkg = CollectionExt.getDataPkg((Structure)container);
            }
        }
        return dataPkg;
    }

    public static List<DataPkg> getDataPkgsFromParentHierarchy(Collection collection) {
        ArrayList<DataPkg> list = new ArrayList<DataPkg>(1);
        if (collection != null) {
            Component parentComp;
            BlockArchitecture compArch = CollectionExt.getRootBlockArchitecture((ModelElement)collection);
            if (compArch != null) {
                DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(compArch);
                if (dataPkg != null) {
                    list.add(dataPkg);
                }
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(DataPkgExt.getDataPkgsFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = CollectionExt.getRootComponent(collection)) != null) {
                DataPkg dataPkg;
                if (parentComp instanceof LogicalComponent && (dataPkg = ((LogicalComponent)parentComp).getOwnedDataPkg()) != null) {
                    list.add(dataPkg);
                }
                list.addAll(DataPkgExt.getDataPkgsFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static List<Interface> getOwnedInterfacesFromParentHierarchy(Collection collection) {
        ArrayList<Interface> list = new ArrayList<Interface>(1);
        if (collection != null) {
            Component parentComp;
            BlockArchitecture compArch = CollectionExt.getRootBlockArchitecture((ModelElement)collection);
            if (compArch != null) {
                list.addAll(InterfacePkgExt.getAllInterfaces(compArch.getOwnedInterfacePkg()));
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(InterfacePkgExt.getOwnedInterfacesFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = CollectionExt.getRootComponent(collection)) != null) {
                if (parentComp instanceof LogicalComponent) {
                    list.addAll(InterfacePkgExt.getAllInterfaces(((LogicalComponent)parentComp).getOwnedInterfacePkg()));
                }
                list.addAll(InterfacePkgExt.getOwnedInterfacesFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static BlockArchitecture getRootBlockArchitecture(ModelElement modelElement) {
        BlockArchitecture arch = null;
        if (modelElement != null) {
            EObject container = modelElement.eContainer();
            if (container instanceof BlockArchitecture) {
                return (BlockArchitecture)container;
            }
            if (container instanceof Component) {
                arch = ComponentExt.getRootBlockArchitecture((ModelElement)((Component)container));
            } else if (container instanceof Structure) {
                arch = StructureExt.getRootBlockArchitecture((Structure)container);
            } else if (container instanceof Classifier) {
                arch = ClassifierExt.getRootBlockArchitecture((ModelElement)((Classifier)container));
            } else {
                EObject container2 = container.eContainer();
                if (container2 != null) {
                    arch = CollectionExt.getRootBlockArchitecture((ModelElement)container2);
                }
            }
        }
        return arch;
    }

    public static Component getRootComponent(Collection collection) {
        Structure structure;
        Component comp = null;
        if (collection != null && (structure = (Structure)collection.eContainer()) != null) {
            comp = StructureExt.getRootComponent(structure);
        }
        return comp;
    }

    public static ComponentArchitecture getRootComponentArchitecture(Collection collection) {
        Structure structure;
        ComponentArchitecture arch = null;
        if (collection != null && (structure = (Structure)collection.eContainer()) != null) {
            arch = StructureExt.getRootComponentArchitecture(structure);
        }
        return arch;
    }

    public static DataPkg getRootDataPkg(Collection collection) {
        DataPkg dataPkg = null;
        if (collection != null) {
            EObject container = collection.eContainer();
            if (container instanceof DataPkg) {
                dataPkg = (DataPkg)container;
            } else if (container instanceof Structure) {
                dataPkg = CollectionExt.getDataPkg((Structure)container);
            }
        }
        return dataPkg;
    }
}

