/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortKind;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.OrientationPortKind;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortAllocation;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.model.helpers.AbstractFunctionExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.helpers.PortExt;

public final class ComponentExchangeExt {
    private ComponentExchangeExt() {
    }

    @Deprecated
    public static Port getSourcePort(ComponentExchange connection) {
        InformationsExchanger source = connection.getSource();
        if (source instanceof ComponentExchangeEnd) {
            return ((ComponentExchangeEnd)source).getPort();
        }
        if (source instanceof Port) {
            return (Port)source;
        }
        return null;
    }

    @Deprecated
    public static Port getTargetPort(ComponentExchange connection) {
        InformationsExchanger target = connection.getTarget();
        if (target instanceof ComponentExchangeEnd) {
            return ((ComponentExchangeEnd)target).getPort();
        }
        if (target instanceof Port) {
            return (Port)target;
        }
        return null;
    }

    @Deprecated
    public static Part getSourcePart(ComponentExchange connection) {
        InformationsExchanger source = connection.getSource();
        if (source instanceof ComponentExchangeEnd) {
            return (Part)((ComponentExchangeEnd)source).getPart();
        }
        if (source instanceof Part) {
            return (Part)source;
        }
        return null;
    }

    public static Collection<Part> getSourceParts(ComponentExchange connection) {
        Part part = ComponentExchangeExt.getSourcePart(connection);
        if (part != null) {
            return Collections.singletonList(part);
        }
        Component sourceComponent = ComponentExchangeExt.getSourceComponent(connection);
        if (sourceComponent != null) {
            return ComponentExt.getRepresentingParts(sourceComponent);
        }
        return Collections.emptyList();
    }

    public static Collection<? extends EObject> getSourcePartsAndEntities(ComponentExchange connection) {
        if (connection.getSource() instanceof Entity) {
            return Collections.singletonList(connection.getSource());
        }
        return ComponentExchangeExt.getSourceParts(connection);
    }

    @Deprecated
    public static Part getTargetPart(ComponentExchange connection) {
        InformationsExchanger target = connection.getTarget();
        if (target instanceof ComponentExchangeEnd) {
            return (Part)((ComponentExchangeEnd)target).getPart();
        }
        if (target instanceof Part) {
            return (Part)target;
        }
        return null;
    }

    public static Collection<Part> getTargetParts(ComponentExchange connection) {
        Part part = ComponentExchangeExt.getTargetPart(connection);
        if (part != null) {
            return Collections.singletonList(part);
        }
        Component targetComponent = ComponentExchangeExt.getTargetComponent(connection);
        if (targetComponent != null) {
            return ComponentExt.getRepresentingParts(targetComponent);
        }
        return Collections.emptyList();
    }

    public static Collection<? extends EObject> getTargetPartsAndEntities(ComponentExchange connection) {
        if (connection.getTarget() instanceof Entity) {
            return Collections.singletonList(connection.getTarget());
        }
        return ComponentExchangeExt.getTargetParts(connection);
    }

    public static Port getOppositePort(ComponentExchange connection, Port port) {
        Port sourcePort = ComponentExchangeExt.getSourcePort(connection);
        if (sourcePort != null && sourcePort.equals(port)) {
            return ComponentExchangeExt.getTargetPort(connection);
        }
        return sourcePort;
    }

    public static Component getSourceComponent(ComponentExchange connection) {
        InformationsExchanger source = connection.getSource();
        if (source instanceof ComponentExchangeEnd) {
            Type abstractType;
            Partition part = ((ComponentExchangeEnd)source).getPart();
            if (part != null && (abstractType = part.getType()) != null && abstractType instanceof Component) {
                return (Component)abstractType;
            }
        } else if (source instanceof Part) {
            Part part = (Part)source;
            Type abstractType = part.getType();
            if (abstractType != null && abstractType instanceof Component) {
                return (Component)abstractType;
            }
        } else if (source instanceof ComponentPort) {
            EObject eContainer = source.eContainer();
            if (eContainer != null && eContainer instanceof Component) {
                return (Component)eContainer;
            }
        } else if (source instanceof PhysicalPort) {
            EObject eContainer = source.eContainer();
            if (eContainer != null && eContainer instanceof Component) {
                return (Component)eContainer;
            }
        } else if (source instanceof Component) {
            return (Component)source;
        }
        return null;
    }

    public static Component getTargetComponent(ComponentExchange connection) {
        InformationsExchanger target = connection.getTarget();
        if (target instanceof ComponentExchangeEnd) {
            Type abstractType;
            Partition part = ((ComponentExchangeEnd)target).getPart();
            if (part != null && (abstractType = part.getType()) != null && abstractType instanceof Component) {
                return (Component)abstractType;
            }
        } else if (target instanceof Part) {
            Part part = (Part)target;
            Type abstractType = part.getType();
            if (abstractType != null && abstractType instanceof Component) {
                return (Component)abstractType;
            }
        } else if (target instanceof ComponentPort) {
            EObject eContainer = target.eContainer();
            if (eContainer != null && eContainer instanceof Component) {
                return (Component)eContainer;
            }
        } else if (target instanceof PhysicalPort) {
            EObject eContainer = target.eContainer();
            if (eContainer != null && eContainer instanceof Component) {
                return (Component)eContainer;
            }
        } else if (target instanceof Component) {
            return (Component)target;
        }
        return null;
    }

    public static boolean isLinkToAnActor(ComponentExchange connection) {
        Component source = ComponentExchangeExt.getSourceComponent(connection);
        Component target = ComponentExchangeExt.getTargetComponent(connection);
        return source != null && target != null && (source instanceof AbstractActor || target instanceof AbstractActor);
    }

    public static boolean isNotLinkToAnActor(ComponentExchange connection) {
        Component source = ComponentExchangeExt.getSourceComponent(connection);
        Component target = ComponentExchangeExt.getTargetComponent(connection);
        return source != null && target != null && !(source instanceof AbstractActor) && !(target instanceof AbstractActor);
    }

    public static List<Object> filteredComponentExchangesBykind(List<Object> objects, ComponentExchangeKind[] kinds1) {
        ArrayList<Object> results = new ArrayList<Object>();
        List<ComponentExchangeKind> kinds = Arrays.asList(kinds1);
        for (Object object : objects) {
            ComponentExchangeKind currentKind;
            if (!(object instanceof ComponentExchange) || !kinds.contains(currentKind = ((ComponentExchange)object).getKind())) continue;
            results.add(object);
        }
        return results;
    }

    public static ComponentExchange createComponentExchange(Part sourcePart, ComponentPort sourcePort, Part targetPart, ComponentPort targetPort, ComponentExchangeKind kind, ComponentPortKind sourceKind1, OrientationPortKind sourceOrientation, ComponentPortKind targetKind1, OrientationPortKind targetOrientation, boolean isMultipart1) {
        ComponentExchangeEnd end;
        ComponentPort portTarget;
        boolean isMultipart = isMultipart1;
        ComponentPort portSource = sourcePort;
        if (portSource == null) {
            Component component = (Component)sourcePart.getAbstractType();
            portSource = FaFactory.eINSTANCE.createComponentPort();
            portSource.setKind(sourceKind1);
            portSource.setOrientation(sourceOrientation);
            component.getOwnedFeatures().add((Object)portSource);
            CapellaElementExt.creationService((EObject)portSource);
        }
        if ((portTarget = targetPort) == null) {
            Component component = (Component)targetPart.getAbstractType();
            portTarget = FaFactory.eINSTANCE.createComponentPort();
            portTarget.setKind(targetKind1);
            portTarget.setOrientation(targetOrientation);
            component.getOwnedFeatures().add((Object)portTarget);
            CapellaElementExt.creationService((EObject)portTarget);
        }
        ComponentExchange componentExchange = FaFactory.eINSTANCE.createComponentExchange();
        componentExchange.setKind(kind);
        ComponentExchangeExt.attachTo(componentExchange, ComponentExchangeExt.getDefaultContainer((CapellaElement)sourcePart, (CapellaElement)targetPart));
        if (!isMultipart || kind == ComponentExchangeKind.DELEGATION) {
            componentExchange.setSource((InformationsExchanger)portSource);
        } else {
            end = FaFactory.eINSTANCE.createComponentExchangeEnd();
            end.setPort((Port)portSource);
            end.setPart((Partition)sourcePart);
            componentExchange.getOwnedComponentExchangeEnds().add((Object)end);
            componentExchange.setSource((InformationsExchanger)end);
        }
        if (!isMultipart) {
            componentExchange.setTarget((InformationsExchanger)portTarget);
        } else {
            end = FaFactory.eINSTANCE.createComponentExchangeEnd();
            end.setPort((Port)portTarget);
            end.setPart((Partition)targetPart);
            componentExchange.getOwnedComponentExchangeEnds().add((Object)end);
            componentExchange.setTarget((InformationsExchanger)end);
        }
        CapellaElementExt.creationService((EObject)componentExchange);
        return componentExchange;
    }

    public static boolean attachTo(ComponentExchange exchange, AbstractFunctionalBlock container) {
        if (container != null && !container.equals(exchange.eContainer())) {
            if (container instanceof Entity && exchange instanceof CommunicationMean) {
                ((Entity)container).getOwnedCommunicationMeans().add((Object)((CommunicationMean)exchange));
            } else {
                container.getOwnedComponentExchanges().add((Object)exchange);
            }
            return true;
        }
        return false;
    }

    public static boolean attachToDefaultContainer(ComponentExchange exchange) {
        return ComponentExchangeExt.attachTo(exchange, ComponentExchangeExt.getDefaultContainer(exchange));
    }

    public static AbstractFunctionalBlock getDefaultContainer(CapellaElement sourcePart, CapellaElement targetPart) {
        EObject container = ComponentExt.getFirstCommonComponentAncestor((EObject)sourcePart, (EObject)targetPart);
        if (container != null && !(container instanceof AbstractFunctionalBlock)) {
            container = EcoreUtil2.getFirstContainer((EObject)container, (EClass)FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK);
        }
        if (container == null || !(container instanceof AbstractFunctionalBlock)) {
            container = BlockArchitectureExt.getContext(ComponentExt.getRootBlockArchitecture((ModelElement)sourcePart));
        }
        return (AbstractFunctionalBlock)container;
    }

    public static AbstractFunctionalBlock getDefaultContainer(ComponentExchange exchange) {
        Component source = ComponentExchangeExt.getSourceComponent(exchange);
        Collection<Part> parts = ComponentExchangeExt.getSourceParts(exchange);
        if (!parts.isEmpty()) {
            source = (CapellaElement)parts.iterator().next();
        }
        Component target = ComponentExchangeExt.getTargetComponent(exchange);
        parts = ComponentExchangeExt.getTargetParts(exchange);
        if (!parts.isEmpty()) {
            target = (CapellaElement)parts.iterator().next();
        }
        return ComponentExchangeExt.getDefaultContainer((CapellaElement)source, (CapellaElement)target);
    }

    public static AbstractFunctionalBlock getDefaultContainerForCategory(ComponentExchange exchange) {
        Component source = ComponentExchangeExt.getSourceComponent(exchange);
        Collection<Part> parts = ComponentExchangeExt.getSourceParts(exchange);
        if (!parts.isEmpty()) {
            source = (CapellaElement)parts.iterator().next();
        }
        Component target = ComponentExchangeExt.getTargetComponent(exchange);
        parts = ComponentExchangeExt.getTargetParts(exchange);
        if (!parts.isEmpty()) {
            target = (CapellaElement)parts.iterator().next();
        }
        return ComponentExchangeExt.getDefaultContainerForCategory((CapellaElement)source, (CapellaElement)target);
    }

    public static AbstractFunctionalBlock getDefaultContainerForCategory(CapellaElement sourcePart, CapellaElement targetPart) {
        EObject container = ComponentExt.getFirstCommonComponentAncestor((EObject)sourcePart, (EObject)targetPart);
        if (container != null && !(container instanceof AbstractFunctionalBlock)) {
            container = EcoreUtil2.getFirstContainer((EObject)container, Arrays.asList(FaPackage.eINSTANCE.getAbstractFunctionalBlock(), FaPackage.eINSTANCE.getAbstractFunctionalStructure()));
        }
        if (container == null || !(container instanceof AbstractFunctionalBlock)) {
            container = BlockArchitectureExt.getContext(ComponentExt.getRootBlockArchitecture((ModelElement)sourcePart));
        }
        return (AbstractFunctionalBlock)container;
    }

    public static Collection<? extends ComponentExchange> getDelegatedComponentExchanges(ComponentPort port, ComponentExchange delegation) {
        Port cp = null;
        cp = delegation.getSourcePort().equals(port) ? delegation.getTargetPort() : delegation.getSourcePort();
        ArrayList<Object> result = new ArrayList<Object>();
        if (cp instanceof ComponentPort) {
            for (ComponentExchange ce : ((ComponentPort)cp).getComponentExchanges()) {
                if (ce.equals(delegation)) continue;
                if (ce.getKind().equals((Object)ComponentExchangeKind.DELEGATION)) {
                    result.addAll(ComponentExchangeExt.getDelegatedComponentExchanges((ComponentPort)cp, ce));
                    continue;
                }
                result.add(ce);
            }
        }
        return result;
    }

    private static List<PortAllocation> getPortAllocations(ComponentExchange cExchange, FunctionalExchange fExchange) {
        Port targetComponentPort;
        ArrayList<PortAllocation> portAllocations = new ArrayList<PortAllocation>();
        ArrayList portAllocationsToCheck = new ArrayList();
        Port sourceComponentPort = cExchange.getSourcePort();
        if (sourceComponentPort != null) {
            portAllocationsToCheck.addAll(sourceComponentPort.getOutgoingPortAllocations());
        }
        if ((targetComponentPort = cExchange.getTargetPort()) != null) {
            portAllocationsToCheck.addAll(targetComponentPort.getOutgoingPortAllocations());
        }
        for (PortAllocation portAllocation : portAllocationsToCheck) {
            if (!portAllocation.getTargetElement().equals(fExchange.getSource()) && !portAllocation.getTargetElement().equals(fExchange.getTarget())) continue;
            portAllocations.add(portAllocation);
        }
        return portAllocations;
    }

    public static boolean isDelegation(ComponentExchange exchange) {
        return exchange.getKind() == ComponentExchangeKind.DELEGATION;
    }

    public static List<CapellaElement> getValidFEAvailableForAllocation(ComponentExchange element) {
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>(1);
        Component source = null;
        Component target = null;
        Port sourcePort = ComponentExchangeExt.getSourcePort(element);
        Port targetPort = ComponentExchangeExt.getTargetPort(element);
        boolean compTargetWithSource = targetPort == null || targetPort instanceof ComponentPort && ((ComponentPort)targetPort).getOrientation() != OrientationPortKind.IN;
        boolean compSourceWithTarget = sourcePort == null || sourcePort instanceof ComponentPort && ((ComponentPort)sourcePort).getOrientation() != OrientationPortKind.IN;
        boolean toSource = compTargetWithSource && sourcePort instanceof ComponentPort && ((ComponentPort)sourcePort).getOrientation() != OrientationPortKind.OUT;
        boolean toTarget = compSourceWithTarget && (targetPort == null || targetPort instanceof ComponentPort && ((ComponentPort)targetPort).getOrientation() != OrientationPortKind.OUT);
        InformationsExchanger informationsExchangerSource = element.getSource();
        InformationsExchanger informationsExchangerTarget = element.getTarget();
        if (informationsExchangerSource != null && informationsExchangerTarget != null) {
            source = ComponentExchangeExt.getSourceComponent(element);
            target = ComponentExchangeExt.getTargetComponent(element);
            if (toTarget) {
                result.addAll(AbstractFunctionExt.getAllAllocatedFunctionalExchangeFiltered((AbstractFunctionalBlock)source, (AbstractFunctionalBlock)target));
            }
            if (toSource) {
                result.addAll(AbstractFunctionExt.getAllAllocatedFunctionalExchangeFiltered((AbstractFunctionalBlock)target, (AbstractFunctionalBlock)source));
            }
        }
        return result;
    }

    public static void synchronizePortAllocations(ComponentExchange cExchange, FunctionalExchange fExchange) {
        Port sourceComponentPort = ComponentExchangeExt.getSourcePort(cExchange);
        Port targetComponentPort = ComponentExchangeExt.getTargetPort(cExchange);
        if (sourceComponentPort != null && targetComponentPort != null && sourceComponentPort instanceof InformationsExchanger && targetComponentPort instanceof InformationsExchanger) {
            Component sourceComponent = ComponentExchangeExt.getSourceComponent(cExchange);
            Component targetComponent = ComponentExchangeExt.getTargetComponent(cExchange);
            AbstractFunction sourceFunction = FunctionalExchangeExt.getSourceFunction(fExchange);
            AbstractFunction targetFunction = FunctionalExchangeExt.getTargetFunction(fExchange);
            List<Component> sourceComponentAndSubComponents = ComponentExt.getAllSubUsedAndDeployedComponents(sourceComponent);
            EList sourceFunctionAllocatingComponents = sourceFunction.getAllocationBlocks();
            List<Component> targetComponentAndSubComponents = ComponentExt.getAllSubUsedAndDeployedComponents(targetComponent);
            EList targetFunctionAllocatingComponents = targetFunction.getAllocationBlocks();
            if (!Collections.disjoint(sourceComponentAndSubComponents, sourceFunctionAllocatingComponents) && !Collections.disjoint(targetComponentAndSubComponents, targetFunctionAllocatingComponents)) {
                ComponentExchangeExt.synchronizeAllocations((InformationsExchanger)sourceComponentPort, fExchange.getSource());
                ComponentExchangeExt.synchronizeAllocations((InformationsExchanger)targetComponentPort, fExchange.getTarget());
            } else if (!Collections.disjoint(sourceComponentAndSubComponents, targetFunctionAllocatingComponents) && !Collections.disjoint(targetComponentAndSubComponents, sourceFunctionAllocatingComponents)) {
                ComponentExchangeExt.synchronizeAllocations((InformationsExchanger)sourceComponentPort, fExchange.getTarget());
                ComponentExchangeExt.synchronizeAllocations((InformationsExchanger)targetComponentPort, fExchange.getSource());
            }
        }
    }

    public static List<? extends ModelElement> evaluateImpactsOfUnsynchronizeAllocations(ComponentExchange cExchange, FunctionalExchange fExchange, boolean forceCleaning) {
        if (forceCleaning) {
            return ComponentExchangeExt.getPortAllocations(cExchange, fExchange);
        }
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        if (ComponentExchangeExt.getExchangesFrom(cExchange, fExchange.getSource()).isEmpty()) {
            result.addAll(ComponentExchangeExt.unsynchronizeAllocations(cExchange.getSource(), fExchange.getSource()));
        }
        if (ComponentExchangeExt.getExchangesFrom(cExchange, fExchange.getTarget()).isEmpty()) {
            result.addAll(ComponentExchangeExt.unsynchronizeAllocations(cExchange.getTarget(), fExchange.getTarget()));
        }
        return result;
    }

    private static void synchronizeAllocations(InformationsExchanger cPort, ActivityNode fPort) {
        if (cPort instanceof ComponentPort) {
            PortExt.attachPort((Port)((ComponentPort)cPort), fPort);
        }
    }

    private static List<ModelElement> unsynchronizeAllocations(InformationsExchanger cPort, ActivityNode fPort) {
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        PortAllocation allocation = ComponentExchangeExt.getPortAllocation(cPort, fPort);
        if (allocation != null) {
            result.add((ModelElement)allocation);
        }
        return result;
    }

    private static List<FunctionalExchange> getExchangesFrom(ComponentExchange cExchange, ActivityNode fPort) {
        ArrayList<FunctionalExchange> result = new ArrayList<FunctionalExchange>();
        if (fPort != null) {
            for (FunctionalExchange exchange : cExchange.getAllocatedFunctionalExchanges()) {
                ActivityNode nodeSource = exchange.getSource();
                ActivityNode nodeTarget = exchange.getTarget();
                if (!fPort.equals(nodeSource) && !fPort.equals(nodeTarget)) continue;
                result.add(exchange);
            }
        }
        return result;
    }

    private static PortAllocation getPortAllocation(InformationsExchanger cPort, ActivityNode fPort) {
        if (cPort instanceof ComponentPort) {
            for (PortAllocation portAllocation : ((ComponentPort)cPort).getOutgoingPortAllocations()) {
                if (!fPort.equals(portAllocation.getTargetElement())) continue;
                return portAllocation;
            }
        }
        return null;
    }

    public static ComponentPort getAttachingPort(Part sourcePart, ComponentExchange ce) {
        Component sourceComponent;
        Port componentExcSource = ce.getSourcePort();
        if (componentExcSource instanceof ComponentPort && ComponentExt.getRepresentingParts(sourceComponent = (Component)componentExcSource.eContainer()).contains(sourcePart)) {
            return (ComponentPort)componentExcSource;
        }
        Port componentExcTarget = ce.getTargetPort();
        if (componentExcTarget instanceof ComponentPort) {
            Component targetComponent = (Component)componentExcTarget.eContainer();
            ComponentExt.getRepresentingParts(targetComponent).contains(sourcePart);
            return (ComponentPort)componentExcTarget;
        }
        return null;
    }
}

