/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.information.CollectionValueReference;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datatype.NumericType;
import org.polarsys.capella.core.data.information.datatype.PhysicalQuantity;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.datavalue.AbstractBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.AbstractEnumerationValue;
import org.polarsys.capella.core.data.information.datavalue.AbstractStringValue;
import org.polarsys.capella.core.data.information.datavalue.BooleanReference;
import org.polarsys.capella.core.data.information.datavalue.ComplexValueReference;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.EnumerationReference;
import org.polarsys.capella.core.data.information.datavalue.NumericReference;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.information.datavalue.StringReference;
import org.polarsys.capella.core.model.helpers.AbstractDependenciesPkgExt;
import org.polarsys.capella.core.model.helpers.ClassifierExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.StructureExt;

public class DataValueExt {
    public static Map<AbstractDependenciesPkg, Collection<EObject>> getDataValueDependencies2(DataValue dataValue) {
        HashMap<AbstractDependenciesPkg, Collection<EObject>> result = new HashMap<AbstractDependenciesPkg, Collection<EObject>>();
        AbstractDependenciesPkgExt.checkDependenciesAndAddToResult(result, (EObject)dataValue.getType());
        return result;
    }

    public static Collection<AbstractDependenciesPkg> getDataValueDependencies(DataValue dataValue) {
        return DataValueExt.getDataValueDependencies2(dataValue).keySet();
    }

    public static ComponentArchitecture getRootComponentArchitecture(DataValue dataValue) {
        ComponentArchitecture arch = null;
        if (dataValue != null) {
            EObject container = dataValue.eContainer();
            if (container instanceof Component) {
                arch = ComponentExt.getRootComponentArchitecture((Component)container);
            } else if (container instanceof Structure) {
                arch = StructureExt.getRootComponentArchitecture((Structure)container);
            }
        }
        return arch;
    }

    public static BlockArchitecture getRootBlockArchitecture(ModelElement modelElement) {
        BlockArchitecture arch = null;
        if (modelElement != null) {
            EObject container = modelElement.eContainer();
            if (container instanceof BlockArchitecture) {
                return (BlockArchitecture)container;
            }
            if (container instanceof Component) {
                arch = ComponentExt.getRootBlockArchitecture((ModelElement)((Component)container));
            } else if (container instanceof Structure) {
                arch = StructureExt.getRootBlockArchitecture((Structure)container);
            } else if (container instanceof Classifier) {
                arch = ClassifierExt.getRootBlockArchitecture((ModelElement)((Classifier)container));
            } else {
                EObject container2 = container.eContainer();
                if (container2 != null) {
                    arch = DataValueExt.getRootBlockArchitecture((ModelElement)container2);
                }
            }
        }
        return arch;
    }

    public static Component getRootComponent(ModelElement modelElement) {
        Component comp = null;
        if (modelElement != null) {
            EObject container = modelElement.eContainer();
            if (container instanceof Component) {
                comp = (Component)container;
            } else if (container instanceof Structure) {
                comp = StructureExt.getRootComponent((Structure)container);
            }
        }
        return comp;
    }

    public static List<DataPkg> getDataPkgsFromParentHierarchy(ModelElement modelElement) {
        ArrayList<DataPkg> list = new ArrayList<DataPkg>(1);
        if (modelElement != null) {
            Component parentComp;
            BlockArchitecture compArch = DataValueExt.getRootBlockArchitecture(modelElement);
            if (compArch != null) {
                DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(compArch);
                if (dataPkg != null) {
                    list.add(dataPkg);
                }
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(DataPkgExt.getDataPkgsFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = DataValueExt.getRootComponent(modelElement)) != null) {
                DataPkg dataPkg = parentComp.getOwnedDataPkg();
                if (dataPkg != null) {
                    list.add(dataPkg);
                }
                list.addAll(DataPkgExt.getDataPkgsFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static boolean isDataValueConsitantWithDataType(DataValue datValue, DataType dataType) {
        return dataType != null && datValue != null && (dataType instanceof NumericType || dataType instanceof PhysicalQuantity ? datValue instanceof NumericValue : (dataType instanceof BooleanType ? datValue instanceof AbstractBooleanValue : (dataType instanceof StringType ? datValue instanceof AbstractStringValue : dataType instanceof Enumeration && datValue instanceof AbstractEnumerationValue)));
    }

    public static DataValue getReferencedValue(EObject eObj) {
        AbstractBooleanValue referencedValue = null;
        if (eObj instanceof BooleanReference) {
            referencedValue = ((BooleanReference)eObj).getReferencedValue();
        } else if (eObj instanceof NumericReference) {
            referencedValue = ((NumericReference)eObj).getReferencedValue();
        } else if (eObj instanceof StringReference) {
            referencedValue = ((StringReference)eObj).getReferencedValue();
        } else if (eObj instanceof EnumerationReference) {
            referencedValue = ((EnumerationReference)eObj).getReferencedValue();
        } else if (eObj instanceof ComplexValueReference) {
            referencedValue = ((ComplexValueReference)eObj).getReferencedValue();
        } else if (eObj instanceof CollectionValueReference) {
            referencedValue = ((CollectionValueReference)eObj).getReferencedValue();
        }
        return referencedValue;
    }

    public static boolean isDataValueReferenceType(Object eObj) {
        return eObj != null && (eObj instanceof BooleanReference || eObj instanceof NumericReference || eObj instanceof StringReference || eObj instanceof EnumerationReference || eObj instanceof ComplexValueReference || eObj instanceof CollectionValueReference);
    }

    public static List<DataValue> getDataValuesFromMapOfEObjectAndEReferences(Map<EObject, List<EReference>> mapOfDataTypeWithFeatures) {
        ArrayList<DataValue> result = new ArrayList<DataValue>(1);
        Set<EObject> keySet = mapOfDataTypeWithFeatures.keySet();
        if (keySet == null) {
            return result;
        }
        for (EObject dataType : keySet) {
            List<EReference> referencesList = mapOfDataTypeWithFeatures.get(dataType);
            for (EReference eReference : referencesList) {
                if (eReference.isMany()) {
                    List listObjects = (List)dataType.eGet((EStructuralFeature)eReference);
                    if (listObjects == null) continue;
                    for (Object object : listObjects) {
                        if (!(object instanceof DataValue)) continue;
                        result.add((DataValue)object);
                    }
                    continue;
                }
                Object object = dataType.eGet((EStructuralFeature)eReference);
                if (object == null || !(object instanceof DataValue)) continue;
                result.add((DataValue)object);
            }
        }
        return result;
    }

    public static String getContainementFeatureofDataValue(DataValue eObject) {
        if (eObject == null) {
            return "";
        }
        EReference eContainmentFeature = eObject.eContainmentFeature();
        if (eContainmentFeature != null) {
            return DataValueExt.getReableFeatureName((EStructuralFeature)eContainmentFeature);
        }
        return eObject.getName();
    }

    public static String getReableFeatureName(EStructuralFeature eStrFea) {
        String eStrFeaName = eStrFea.getName();
        String readableFeatureName = eStrFeaName.replaceAll("owned", "");
        return readableFeatureName;
    }

    public static boolean isDataValueTyped(DataValue ownedDefaultValue) {
        if (ownedDefaultValue == null) {
            return false;
        }
        AbstractType type = ownedDefaultValue.getAbstractType();
        return type != null;
    }
}

