/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.SystemComponent;
import org.polarsys.capella.core.data.cs.SystemComponentCapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;

public class SystemComponentExt {
    public static boolean isRealizationInvolved(SystemComponent component, CapabilityRealization capabilityRealization) {
        boolean isRealizationInvolved = false;
        for (SystemComponentCapabilityRealizationInvolvement systemComponentCapabilityRealizationInvolvement : component.getParticipationsInCapabilityRealizations()) {
            if (!systemComponentCapabilityRealizationInvolvement.getInvolver().equals(capabilityRealization)) continue;
            isRealizationInvolved = true;
            break;
        }
        return isRealizationInvolved;
    }

    public static void removeInvolvedCapabilityRealisationUseCase(SystemComponent cpnt, CapabilityRealization capabilityRealisation) {
        SystemComponentCapabilityRealizationInvolvement systemCapabilityInvolvement = null;
        ListIterator it = cpnt.getParticipationsInCapabilityRealizations().listIterator();
        while (it.hasNext()) {
            SystemComponentCapabilityRealizationInvolvement inv = (SystemComponentCapabilityRealizationInvolvement)it.next();
            if (!inv.getInvolver().equals(capabilityRealisation)) continue;
            systemCapabilityInvolvement = inv;
        }
        if (systemCapabilityInvolvement != null) {
            ((CapabilityRealization)capabilityRealisation.eContainer()).getOwnedSystemComponentCapabilityRealizations().remove(systemCapabilityInvolvement);
            systemCapabilityInvolvement.destroy();
        }
    }

    public static List<CapabilityRealization> getInvolvedCapabilityRealisations(SystemComponent cpnt) {
        return SystemComponentExt.getInvolvedCapabilityRealisations(cpnt, false);
    }

    public static List<CapabilityRealization> getInvolvedCapabilityRealisations(SystemComponent cpnt, boolean onlyGenerated) {
        ArrayList<CapabilityRealization> involvedCapabilities = new ArrayList<CapabilityRealization>();
        for (SystemComponentCapabilityRealizationInvolvement systemCapabilityInvolvement : cpnt.getParticipationsInCapabilityRealizations()) {
            CapabilityRealization capabilityRealizationUseCase = (CapabilityRealization)systemCapabilityInvolvement.getInvolver();
            if (capabilityRealizationUseCase == null) continue;
            involvedCapabilities.add(capabilityRealizationUseCase);
        }
        return involvedCapabilities;
    }

    public static void addInvolvedCapabilityRealisation(SystemComponent cpnt, CapabilityRealization capabilityRealisationUseCase) {
        if (cpnt != null && capabilityRealisationUseCase != null && !SystemComponentExt.getInvolvedCapabilityRealisations(cpnt).contains(capabilityRealisationUseCase)) {
            SystemComponentCapabilityRealizationInvolvement capabilityInv = CsFactory.eINSTANCE.createSystemComponentCapabilityRealizationInvolvement();
            capabilityInv.setInvolved((InvolvedElement)cpnt);
            capabilityInv.setInvolver((InvolverElement)capabilityRealisationUseCase);
            ((CapabilityRealization)capabilityRealisationUseCase.eContainer()).getOwnedSystemComponentCapabilityRealizations().add((Object)capabilityInv);
        }
    }

    public static List<CapellaElement> getCapabilityRealizationUseCasesFiltered(SystemComponent currentComponent, CapellaElement element) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>(1);
        for (CapabilityRealization capabilityRealization : CapellaElementExt.getAllCapabilityRealizationInvolvedWith(element)) {
            if (SystemComponentExt.isRealizationInvolved(currentComponent, capabilityRealization)) continue;
            availableElements.add((CapellaElement)capabilityRealization);
        }
        return availableElements;
    }
}

