/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.command.recorder.core.manager.utils;

public enum OperationEnum {
    DONE(4, "DONE"),
    UNDO(10, "UNDONE"),
    REDO(9, "REDONE"),
    NOT_OK(7, "NOT_OK"),
    UNDEFINED(-1, "???");

    private final int _eventType;
    private final String _literal;

    public int getClosingEvent() {
        return this._eventType;
    }

    public String getLiteral() {
        return this._literal;
    }

    private OperationEnum(int eventType, String literal) {
        this._eventType = eventType;
        this._literal = literal;
    }

    public static OperationEnum getOperationEnum(int closingEventType) {
        OperationEnum result = UNDEFINED;
        int i = 0;
        while (i < OperationEnum.values().length) {
            if (closingEventType == OperationEnum.values()[i].getClosingEvent()) {
                result = OperationEnum.values()[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public static OperationEnum getOperationEnum(String literal) {
        OperationEnum result = UNDEFINED;
        int i = 0;
        while (i < OperationEnum.values().length) {
            if (literal.equals(OperationEnum.values()[i].getLiteral())) {
                result = OperationEnum.values()[i];
                break;
            }
            ++i;
        }
        return result;
    }
}

