/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.command.recorder.core.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.polarsys.capella.common.command.recorder.core.exception.RecorderException;
import org.polarsys.capella.common.command.recorder.core.manager.AbstractRecorderManager;
import org.polarsys.capella.common.command.recorder.core.output.OutputHelper;
import org.polarsys.capella.common.command.recorder.core.output.OutputRecorder;
import org.polarsys.capella.common.command.recorder.core.preferences.RecorderCorePreferenceServices;
import org.polarsys.capella.common.command.recorder.core.project.AbstractProjectRecorder;
import org.polarsys.capella.common.command.recorder.core.project.utils.ProjectUtils;
import org.polarsys.capella.common.command.recorder.core.recorder.AbstractRecorder;

public abstract class AbstractProjectRecorderManager
extends AbstractRecorderManager
implements IResourceChangeListener {
    private IWorkspace _wksp = ResourcesPlugin.getWorkspace();
    private final Collection<String> _natureIds;

    public final Collection<String> getMatchingNatures() {
        return this._natureIds;
    }

    public AbstractProjectRecorderManager(Collection<String> natureIdsToMatch) {
        this._natureIds = natureIdsToMatch == null ? Collections.EMPTY_SET : natureIdsToMatch;
        this.setOutPutManager(new OutputRecorder());
    }

    @Override
    public void startup() throws RecorderException {
        super.startup();
        this._wksp.addResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public void shutDown() throws RecorderException {
        super.shutDown();
        this._wksp.removeResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    protected void initRecorders() {
        super.initRecorders();
        boolean createNewLog = RecorderCorePreferenceServices.isNewLogFileShouldBeCreatedOnStartUp();
        for (IProject project : ProjectUtils.getAllProjectsOfType(this.getMatchingNatures())) {
            this.addProjectRecorder(project, createNewLog);
        }
    }

    protected void addProjectRecorder(IProject project, boolean createNewRecordFile) {
        if (project != null && !this.isProjectHasBeenAlreadyAdded(project) && ProjectUtils.isProjectOfType(project, this.getMatchingNatures())) {
            this.addRecorder(this.createProjectRecorder(project), createNewRecordFile);
        }
    }

    protected abstract AbstractProjectRecorder createProjectRecorder(IProject var1);

    protected AbstractProjectRecorder getRecorder(IProject project) {
        for (AbstractRecorder recorder : this._recorders) {
            if (!((AbstractProjectRecorder)recorder).getProject().equals((Object)project)) continue;
            return (AbstractProjectRecorder)recorder;
        }
        return null;
    }

    protected boolean isProjectHasBeenAlreadyAdded(IProject project) {
        return this.getRecorder(project) != null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta rootDelta = event.getDelta();
        IResourceDelta docDelta = rootDelta.findMember((IPath)new Path("/"));
        if (docDelta == null) {
            return;
        }
        final ArrayList added = new ArrayList();
        final ArrayList deleted = new ArrayList();
        final ArrayList closed = new ArrayList();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                if (delta.getResource().getType() != 4 || delta.getKind() != 1 && delta.getKind() != 2 && (delta.getKind() != 4 || (delta.getFlags() & 0x4000) == 0)) {
                    return true;
                }
                IProject project = (IProject)delta.getResource();
                switch (delta.getKind()) {
                    case 1: {
                        added.add(project);
                        break;
                    }
                    case 2: {
                        deleted.add(project);
                        break;
                    }
                    case 4: {
                        if ((delta.getFlags() & 0x4000) == 0) break;
                        if (project.isOpen()) {
                            added.add(project);
                            break;
                        }
                        closed.add(project);
                    }
                }
                return true;
            }
        };
        try {
            docDelta.accept(visitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        for (IProject current : added) {
            this.addProjectRecorder(current, false);
        }
        AbstractProjectRecorder recorder = null;
        for (IProject current : deleted) {
            recorder = this.getRecorder(current);
            this.removeRecorder(recorder);
            if (!RecorderCorePreferenceServices.isRecordsShouldBeDeletedWithProject()) continue;
            OutputHelper.deleteFile(OutputHelper.getDir(recorder));
        }
        for (IProject current : closed) {
            this.removeRecorder(this.getRecorder(current));
        }
    }
}

