/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.command.recorder.core.project.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ProjectUtils {
    public static boolean isProjectOfType(IProject project, String natureIdToMatch) {
        return natureIdToMatch == null || natureIdToMatch.equals("") ? true : ProjectUtils.isProjectOfType(project, Collections.singleton(natureIdToMatch));
    }

    public static boolean isProjectOfType(IProject project, Collection<String> natureIdsToMatch) {
        boolean result = false;
        if (natureIdsToMatch == null || natureIdsToMatch.isEmpty()) {
            return true;
        }
        try {
            String[] projectNatures = project.getDescription().getNatureIds();
            result = ProjectUtils.matche(projectNatures, natureIdsToMatch);
        }
        catch (CoreException exception) {
            result = false;
        }
        return result;
    }

    public static Collection<IProject> getAllProjectsOfType(String natureIdToMatch) {
        return ProjectUtils.getAllProjectsOfType(Collections.singleton(natureIdToMatch));
    }

    public static Collection<IProject> getAllProjectsOfType(Collection<String> natureIdsToMatch) {
        HashSet<IProject> result = new HashSet<IProject>();
        IWorkspace root = ResourcesPlugin.getWorkspace();
        IProject[] projects = root.getRoot().getProjects();
        boolean shouldBeFilteredWithNature = natureIdsToMatch != null && !natureIdsToMatch.isEmpty();
        IProject project = null;
        boolean keep = false;
        int i = 0;
        while (i < projects.length) {
            keep = false;
            project = projects[i];
            keep = project.isAccessible();
            if (keep && shouldBeFilteredWithNature) {
                keep = ProjectUtils.isProjectOfType(project, natureIdsToMatch);
            }
            if (keep) {
                result.add(project);
            }
            ++i;
        }
        return result;
    }

    private static boolean matche(String[] a, Collection<String> b) {
        boolean result = false;
        String[] stringArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (b.contains(str)) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }
}

