/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.scrutiny.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.polarsys.kitalpha.model.common.scrutiny.Messages;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.RegistryHelper;

public class ModelScrutinyRegistry {
    private static Logger LOGGER = Logger.getLogger(ModelScrutinyRegistry.class);
    private Map<String, RegistryElement> registry = new HashMap<String, RegistryElement>();
    public static final ModelScrutinyRegistry INSTANCE = new ModelScrutinyRegistry();

    private ModelScrutinyRegistry() {
    }

    public Map<String, RegistryElement> initRegistry() {
        this.dispose();
        IExtension[] extensions = RegistryHelper.getAllExtensionsFor("org.polarsys.kitalpha.model.common.scrutiny.scrutinize");
        if (extensions != null && extensions.length > 0) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (config.getName().equals("scrutiny")) {
                        String id = config.getAttribute("id");
                        String name = config.getAttribute("name");
                        IConfigurationElement[] classes = config.getChildren("class");
                        RegistryElement re = new RegistryElement(id, name);
                        this.registry.put(id, re);
                        if (classes != null && classes.length > 0) {
                            IConfigurationElement[] iConfigurationElementArray2 = classes;
                            int n5 = classes.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement finderClass = iConfigurationElementArray2[n6];
                                try {
                                    Object finder = finderClass.createExecutableExtension("scrutinize");
                                    re.addFinder((IScrutinize)finder);
                                }
                                catch (CoreException e) {
                                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                                }
                                ++n6;
                            }
                        } else {
                            LOGGER.error(Messages.MODEL_SCRUTINY_NO_SCRUTINIZE_FOUND);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            LOGGER.warn((Object)Messages.MODEL_SCRUTINY_NO_EXTENSION_FOUND);
        }
        return this.registry;
    }

    public RegistryElement getRegistryElement(String id) {
        if (this.registry.containsKey(id)) {
            return this.registry.get(id);
        }
        RuntimeException re = new RuntimeException(Messages.NO_SUCH_REGISTRY_ELEMENT);
        LOGGER.error((Object)Messages.NO_SUCH_REGISTRY_ELEMENT, (Throwable)re);
        throw re;
    }

    private void dispose() {
        this.registry.clear();
    }

    public Map<String, RegistryElement> getRegistry() {
        return this.registry;
    }

    public static class RegistryElement {
        private String id;
        private String name;
        private Collection<IScrutinize> finders;

        public RegistryElement(String id, String name) {
            this.id = id;
            this.name = name;
            this.finders = new HashSet<IScrutinize>();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Collection<IScrutinize> getFinders() {
            return this.finders;
        }

        public void addFinder(IScrutinize finder) {
            this.finders.add(finder);
        }
    }
}

