/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaCopyAction;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaCutAction;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaDeleteAction;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaPasteAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.RenameAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SelectionHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SortContentAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SortSelectionAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.MoveDownAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.MoveUpAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.core.ui.resources.CapellaUIResourcesPlugin;

public class EditCommonActionProvider
extends CommonActionProvider {
    private BaseSelectionListenerAction _copyAction;
    private BaseSelectionListenerAction _cutAction;
    private CapellaDeleteAction _deleteAction;
    private BaseSelectionListenerAction _moveDown;
    private BaseSelectionListenerAction _moveUp;
    private BaseSelectionListenerAction _sortContent;
    private BaseSelectionListenerAction _sortSelection;
    private BaseSelectionListenerAction _pasteAction;
    private RenameAction _renameAction;

    public void dispose() {
        ISelectionProvider selectionProvider = this.getActionSite().getViewSite().getSelectionProvider();
        if (this._cutAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._cutAction);
            this._cutAction = null;
        }
        if (this._copyAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._copyAction);
            this._copyAction = null;
        }
        if (this._pasteAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._pasteAction);
            this._pasteAction = null;
        }
        if (this._deleteAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._deleteAction);
            this._deleteAction.dispose();
            this._deleteAction = null;
        }
        if (this._moveUp != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._moveUp);
            this._moveUp = null;
        }
        if (this._moveDown != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._moveDown);
            this._moveDown = null;
        }
        if (this._sortContent != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._sortContent);
            this._sortContent = null;
        }
        if (this._sortSelection != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._sortSelection);
            this._sortSelection = null;
        }
        if (this._renameAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._renameAction);
            this._renameAction = null;
        }
        super.dispose();
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this._cutAction);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this._copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this._pasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this._deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this._renameAction);
        TextActionHandler textActionHandler = new TextActionHandler(actionBars);
        textActionHandler.setCutAction((IAction)this._cutAction);
        textActionHandler.setCopyAction((IAction)this._copyAction);
        textActionHandler.setPasteAction((IAction)this._pasteAction);
        textActionHandler.setDeleteAction((IAction)this._deleteAction);
        this._renameAction.setTextActionHandler(textActionHandler);
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.appendToGroup("group.edit", (IAction)this._cutAction);
        menu.appendToGroup("group.edit", (IAction)this._copyAction);
        menu.appendToGroup("group.edit", (IAction)this._pasteAction);
        menu.appendToGroup("group.edit", (IAction)this._deleteAction);
        menu.appendToGroup("group.edit", (IContributionItem)new Separator());
        menu.appendToGroup("group.edit", (IAction)this._moveUp);
        menu.appendToGroup("group.edit", (IAction)this._sortContent);
        menu.appendToGroup("group.edit", (IAction)this._sortSelection);
        menu.appendToGroup("group.edit", (IAction)this._moveDown);
        menu.appendToGroup("group.edit", (IContributionItem)new Separator());
    }

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        ICommonViewerSite commonViewSite = site.getViewSite();
        if (!(commonViewSite instanceof ICommonViewerWorkbenchSite)) {
            return;
        }
        ICommonViewerWorkbenchSite commonViewerWorkbenchSite = (ICommonViewerWorkbenchSite)commonViewSite;
        CapellaCommonNavigator activePart = (CapellaCommonNavigator)commonViewerWorkbenchSite.getPart();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ISelectionProvider selectionProvider = commonViewSite.getSelectionProvider();
        this._cutAction = new CapellaCutAction(site.getStructuredViewer());
        this._cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this._cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this._cutAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._cutAction, selectionProvider);
        this._copyAction = new CapellaCopyAction(site.getStructuredViewer()){

            public void run() {
                super.run();
                EditCommonActionProvider.this._pasteAction.selectionChanged(this.getStructuredSelection());
            }
        };
        this._copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this._copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this._copyAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._copyAction, selectionProvider);
        this._pasteAction = new CapellaPasteAction();
        this._pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this._pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this._pasteAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._pasteAction, selectionProvider);
        this._deleteAction = new CapellaDeleteAction();
        this._deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this._deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this._deleteAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._deleteAction, selectionProvider);
        this._moveUp = new MoveUpAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._moveUp, selectionProvider);
        this._moveDown = new MoveDownAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._moveDown, selectionProvider);
        this._sortContent = new SortContentAction();
        this._sortContent.setImageDescriptor(CapellaUIResourcesPlugin.getDefault().getImageDescriptor("full/obj16/capella_sort.gif"));
        this._sortContent.setDisabledImageDescriptor(CapellaUIResourcesPlugin.getDefault().getImageDescriptor("full/obj16/capella_sort_disabled.gif"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._sortContent, selectionProvider);
        this._sortSelection = new SortSelectionAction();
        this._sortSelection.setImageDescriptor(CapellaUIResourcesPlugin.getDefault().getImageDescriptor("full/obj16/capella_sort.gif"));
        this._sortSelection.setDisabledImageDescriptor(CapellaUIResourcesPlugin.getDefault().getImageDescriptor("full/obj16/capella_sort_disabled.gif"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._sortSelection, selectionProvider);
        this._renameAction = new RenameAction(activePart);
        this._renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._renameAction, selectionProvider);
    }
}

