/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.polarsys.capella.common.ui.services.helper.EObjectLabelProviderHelper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.ImpactAnalysisAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.NavigateAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SelectionHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.ShowInDiagramAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.internal.navigate.NavigationAdvisor;

public class ModelElementActionProvider
extends CommonActionProvider {
    private ImpactAnalysisAction _impactAnalysisAction;
    private ShowInDiagramAction _showInDiagramAction;

    protected void addAction(IMenuManager menu_p, String groupId_p, IAction action_p) {
        ActionContributionItem item = new ActionContributionItem(action_p){

            public boolean isDirty() {
                return true;
            }

            public boolean isDynamic() {
                return true;
            }
        };
        if (groupId_p != null) {
            menu_p.appendToGroup(groupId_p, (IContributionItem)item);
        } else {
            menu_p.add((IContributionItem)item);
        }
    }

    public void dispose() {
        ISelectionProvider selectionProvider = this.getActionSite().getViewSite().getSelectionProvider();
        if (this._showInDiagramAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._showInDiagramAction);
            this._showInDiagramAction = null;
        }
        if (this._impactAnalysisAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this._impactAnalysisAction);
            this._impactAnalysisAction = null;
        }
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu_p) {
        menu_p.appendToGroup("group.show", (IAction)this._showInDiagramAction);
        MenuManager subMenuManager = new MenuManager(Messages.ModelElementActionProvider_Goto_Menu_Title, "Dynamic.Goto"){

            public void fill(Menu parent_p, int index_p) {
                super.fill(parent_p, index_p);
                MenuItem[] menuItemArray = parent_p.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    if (Messages.ModelElementActionProvider_Goto_Menu_Title.equals(item.getText())) {
                        item.setImage(CapellaNavigatorPlugin.getDefault().getImage("capella_16.png"));
                        break;
                    }
                    ++n2;
                }
            }
        };
        this.fillGotoMenuManager((IMenuManager)subMenuManager);
        menu_p.insertAfter("group.goto", (IContributionItem)subMenuManager);
        menu_p.insertAfter("group.accelerator", (IAction)this._impactAnalysisAction);
    }

    protected void fillGotoMenuManager(IMenuManager menu_p) {
        IStructuredSelection selection = (IStructuredSelection)this.getActionSite().getViewSite().getSelectionProvider().getSelection();
        if (CapellaResourceHelper.isSemanticElements((Collection)selection.toList())) {
            EObject element = (EObject)selection.getFirstElement();
            Set<EObject> navigableElements = NavigationAdvisor.getInstance().getNavigableElements(element);
            if (!navigableElements.isEmpty()) {
                StructuredViewer viewer = this.getActionSite().getStructuredViewer();
                for (EObject currentModelElement : navigableElements) {
                    NavigateAction action = new NavigateAction(currentModelElement, viewer);
                    action.setText(EObjectLabelProviderHelper.getText((EObject)currentModelElement));
                    action.setImageDescriptor(ImageDescriptor.createFromImage((Image)EObjectLabelProviderHelper.getImage((EObject)currentModelElement)));
                    this.addAction(menu_p, null, (IAction)action);
                }
            }
        }
    }

    public void init(ICommonActionExtensionSite site_p) {
        super.init(site_p);
        ICommonViewerSite commonViewSite = site_p.getViewSite();
        this._showInDiagramAction = new ShowInDiagramAction();
        this._showInDiagramAction.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("showInDiagram.gif"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._showInDiagramAction, commonViewSite.getSelectionProvider());
        this._impactAnalysisAction = new ImpactAnalysisAction();
        this._impactAnalysisAction.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("elcl16/ch_callers.gif"));
        this._impactAnalysisAction.setDisabledImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("dlcl16/ch_callers.gif"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this._impactAnalysisAction, commonViewSite.getSelectionProvider());
    }
}

