/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers.Messages;
import org.polarsys.capella.core.sirius.ui.actions.NewRepresentationAction;
import org.polarsys.capella.core.sirius.ui.actions.NewScenarioRepresentationAction;

public class NewRepresentationActionProvider
extends CommonActionProvider {
    private static final String NewRepresentationAction = null;

    public void fillContextMenu(IMenuManager menu_p) {
        Collection selectedViewpoints;
        Collection descriptions;
        IModel currentElementModel;
        IModel sessionModel;
        EObject firstSelectedEObject;
        Session currentSession;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof EObject && (currentSession = SessionManager.INSTANCE.getSession(firstSelectedEObject = (EObject)firstElement)) != null && (sessionModel = ILibraryManager.INSTANCE.getModel(TransactionHelper.getEditingDomain((Session)currentSession))).equals(currentElementModel = ILibraryManager.INSTANCE.getModel(firstSelectedEObject)) && !(descriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(selectedViewpoints = currentSession.getSelectedViewpoints(false), firstSelectedEObject)).isEmpty()) {
            MenuManager newDiagramMenu = new MenuManager(Messages.NewRepresentationActionProvider_NewRepresentationAction_Title, "capella.project.diagrams.menu");
            for (RepresentationDescription description : descriptions) {
                if (!DialectManager.INSTANCE.canCreate(firstSelectedEObject, description)) continue;
                NewRepresentationAction representationAction = this.buildNewRepresentationAction(firstSelectedEObject, description, currentSession);
                newDiagramMenu.add((IAction)representationAction);
            }
            if (firstSelectedEObject instanceof AbstractCapability) {
                AbstractCapability capa = (AbstractCapability)firstSelectedEObject;
                for (Viewpoint vp : selectedViewpoints) {
                    for (RepresentationDescription representationDescription : vp.getOwnedRepresentations()) {
                        if (!(representationDescription instanceof SequenceDiagramDescription)) continue;
                        SequenceDiagramDescription sdd = (SequenceDiagramDescription)representationDescription;
                        String precondition = sdd.getPreconditionExpression();
                        try {
                            if (!InterpreterUtil.getInterpreter((EObject)capa).evaluateBoolean((EObject)capa, precondition)) continue;
                            NewScenarioRepresentationAction action = new NewScenarioRepresentationAction((RepresentationDescription)sdd, capa, currentSession);
                            newDiagramMenu.add((IAction)action);
                        }
                        catch (EvaluationException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (newDiagramMenu.getSize() > 0) {
                menu_p.appendToGroup("group.new", (IContributionItem)newDiagramMenu);
            }
        }
    }

    private NewRepresentationAction buildNewRepresentationAction(EObject selectedEObject_p, RepresentationDescription description_p, Session session_p) {
        NewRepresentationAction action = new NewRepresentationAction(description_p, selectedEObject_p, session_p);
        return action;
    }
}

