/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.ICommandStackSelectionProvider;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.NavigatorEditingDomainDispatcher;

public class UndoRedoActionProvider
extends CommonActionProvider
implements ICommandStackSelectionProvider {
    private UndoActionHandler undoActionHandler;
    private RedoActionHandler redoActionHandler;

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        IWorkbenchPartSite workbenchPartSite = ((ICommonViewerWorkbenchSite)site.getViewSite()).getSite();
        this.undoActionHandler = new UndoActionHandler(workbenchPartSite, null);
        this.redoActionHandler = new RedoActionHandler(workbenchPartSite, null);
        NavigatorEditingDomainDispatcher.registerCommandStackSelectionProvider(this);
        this.updateActionBars();
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoActionHandler);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoActionHandler);
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.appendToGroup("group.edit", (IAction)this.undoActionHandler);
        menu.appendToGroup("group.edit", (IAction)this.redoActionHandler);
    }

    public void updateActionBars() {
        TransactionalEditingDomain editingDomain = null;
        ISelection selection = null;
        ActionContext ctx = this.getContext();
        selection = ctx != null ? ctx.getSelection() : this.getActionSite().getViewSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            Object selectedElement;
            IStructuredSelection structuralSel = (IStructuredSelection)selection;
            if (structuralSel.size() == 1 && (selectedElement = structuralSel.getFirstElement()) instanceof RepresentationItemImpl) {
                editingDomain = TransactionHelper.getEditingDomain((EObject)((RepresentationItemImpl)selectedElement).getDRepresentationDescriptor().getRepresentation());
            }
            boolean isEObjectList = true;
            List selectionList = ((IStructuredSelection)selection).toList();
            for (Object obj : selectionList) {
                if (obj instanceof EObject) continue;
                isEObjectList = false;
            }
            if (isEObjectList) {
                editingDomain = TransactionHelper.getEditingDomain((Collection)selectionList);
            }
        }
        if (editingDomain != null) {
            IUndoContext undoContext = ((IWorkspaceCommandStack)editingDomain.getCommandStack()).getDefaultUndoContext();
            if (this.undoActionHandler != null) {
                this.undoActionHandler.setContext(undoContext);
            }
            if (this.redoActionHandler != null) {
                this.redoActionHandler.setContext(undoContext);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.undoActionHandler.dispose();
        this.undoActionHandler = null;
        this.redoActionHandler.dispose();
        this.redoActionHandler = null;
        NavigatorEditingDomainDispatcher.unregisterCommandStackSelectionProvider(this);
    }

    @Override
    public void commandStackSelectionChanged(ISelection selection) {
        this.updateActionBars();
    }
}

