/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.drop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.model.copypaste.SharedCopyPasteElements;
import org.polarsys.capella.core.model.helpers.move.MoveHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaCopyToClipboardCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaPasteCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.PasteCommandHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.drop.AbstractCapellaDropAdapterAssistant;
import org.polarsys.capella.core.platform.sirius.ui.navigator.drop.BasicDropConstraints;

public class ExplorerDropAdapterAssistant
extends AbstractCapellaDropAdapterAssistant {
    protected BasicDropConstraints _basicDropConstraints = null;

    protected BasicDropConstraints getBasicConstraints() {
        if (this._basicDropConstraints == null) {
            this._basicDropConstraints = new BasicDropConstraints();
        }
        return this._basicDropConstraints;
    }

    protected MoveHelper getMoveHelper() {
        return MoveHelper.getInstance();
    }

    @Override
    public IStatus handleDrop(Object target_p, int operation_p, DropTargetEvent dropTargetEvent_p) {
        Object currentTarget = target_p;
        if (currentTarget == null || dropTargetEvent_p.data == null) {
            return Status.CANCEL_STATUS;
        }
        IStatus status = null;
        List<EObject> modelElements = null;
        TransferData currentTransfer = dropTargetEvent_p.currentDataType;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(currentTransfer)) {
            modelElements = this.getSelectedElements();
        }
        if (modelElements != null && !modelElements.isEmpty()) {
            if (2 == operation_p) {
                status = this.doHandleDrop(currentTarget, operation_p, dropTargetEvent_p, modelElements);
            } else if (1 == operation_p) {
                status = this.doHandleDrop(currentTarget, operation_p, dropTargetEvent_p, modelElements);
            } else {
                return Status.CANCEL_STATUS;
            }
        }
        return status;
    }

    private IStatus doHandleDrop(Object target_p, int operation_p, DropTargetEvent event_p, List<EObject> modelElements_p) {
        Object currentTarget = target_p;
        EObject nextContainer = (EObject)currentTarget;
        TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((EObject)nextContainer);
        DragAndDropCommand dropCommand = new DragAndDropCommand((EditingDomain)editingDomain, nextContainer, this.getLocation(event_p), event_p.operations, event_p.detail, modelElements_p){

            protected boolean prepareDropMoveOn() {
                this.dropCommand = new CompoundCommand();
                PasteCommandHelper.createPasteCommands((Collection)this.collection, (CompoundCommand)((CompoundCommand)this.dropCommand), (EObject)((EObject)this.owner), null, (EditingDomain)this.domain, (int)-1, (boolean)true);
                this.dragCommand = RemoveCommand.create((EditingDomain)this.domain, (Collection)this.collection);
                boolean result = this.dragCommand.canExecute() && this.dropCommand.canExecute();
                return result;
            }

            protected boolean prepareDropCopyOn() {
                boolean result = false;
                this.dragCommand = new CapellaCopyToClipboardCommand(this.domain, this.collection, null);
                if (this.dragCommand.canExecute()) {
                    this.dragCommand.execute();
                    this.isDragCommandExecuted = true;
                    this.dropCommand = new CommandWrapper((Command)new CapellaPasteCommand(this.domain, this.owner, null, -1)){

                        public void execute() {
                            super.execute();
                            domain.getClipboard().clear();
                            SharedCopyPasteElements.getInstance().clear();
                        }
                    };
                    if (this.dropCommand.canExecute()) {
                        result = true;
                    } else {
                        this.dragCommand.undo();
                        this.isDragCommandExecuted = false;
                    }
                }
                return result;
            }
        };
        editingDomain.getCommandStack().execute((Command)dropCommand);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validateDrop(Object target_p, int operation_p, TransferData transferType_p) {
        if (!(target_p instanceof EObject)) {
            return new Status(1, CapellaNavigatorPlugin.getDefault().getPluginId(), "Target must be an EObject.");
        }
        EObject targetElement = (EObject)target_p;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType_p)) {
            List<EObject> selectedModelElements = this.getSelectedElements();
            if (selectedModelElements.isEmpty()) {
                return new Status(1, CapellaNavigatorPlugin.getDefault().getPluginId(), "An error occurred during the drop operation.");
            }
            boolean isSemanticallyCorrect = this.getMoveHelper().checkSemanticRules(selectedModelElements, targetElement).isOK();
            if (!isSemanticallyCorrect) {
                return new Status(1, CapellaNavigatorPlugin.getDefault().getPluginId(), "Semantic rules failed.");
            }
            if (this.getMoveHelper().checkEMFRules(selectedModelElements, targetElement).isOK() && this.getBasicConstraints().canDrop(selectedModelElements, targetElement, operation_p)) {
                return Status.OK_STATUS;
            }
        }
        return new Status(1, CapellaNavigatorPlugin.getDefault().getPluginId(), "Needs to be drop onto a right container.");
    }

    private List<EObject> getSelectedElements() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            ArrayList<EObject> modelElements = new ArrayList<EObject>();
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                if (!(object instanceof EObject)) continue;
                EObject element = (EObject)object;
                modelElements.add(element);
            }
            return modelElements;
        }
        return new ArrayList<EObject>(0);
    }
}

