/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.action.RefreshActionListenerRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.handlers.AbstractDiagramCommandHandler;
import org.polarsys.capella.core.platform.sirius.ui.navigator.handlers.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.helpers.AbstractFixDiagramHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.helpers.FixCustomFeaturesHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.helpers.FixDAnnotationsHelper;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public abstract class AbstractFixDiagramsHandler
extends AbstractDiagramCommandHandler {
    private String dialogConfirmationMessage;
    private String onlyCleanMessage;
    private String jobName;
    private AbstractFixDiagramHelper fixHelper;

    public Object execute(ExecutionEvent event_p) throws ExecutionException {
        int rc;
        final boolean[] checked = new boolean[1];
        boolean fixConfirmed = false;
        if (this.getOnlyCleanMessage() != null) {
            MessageDialogWithToggle messageDialogWithToggle = new MessageDialogWithToggle(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.AbstractFixCommandHandler_ConfirmFix_Title, null, this.getDialogConfirmationMessage(), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1, this.getOnlyCleanMessage(), false);
            rc = messageDialogWithToggle.open();
            fixConfirmed = rc == 0;
            checked[0] = messageDialogWithToggle.getToggleState();
        } else {
            MessageDialog messageDialog = new MessageDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.AbstractFixCommandHandler_ConfirmFix_Title, null, this.getDialogConfirmationMessage(), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
            rc = messageDialog.open();
            boolean bl = fixConfirmed = rc == 0;
        }
        if (!fixConfirmed) {
            return null;
        }
        final IFile airdFile = (IFile)this.getSelection().getFirstElement();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                final Session session = SessionHelper.getSession((IFile)airdFile);
                WorkspaceJob job = new WorkspaceJob(AbstractFixDiagramsHandler.this.getJobName()){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        final HashSet modifiedDiagrams = new HashSet();
                        ExecutionManager executionManager = TransactionHelper.getExecutionManager((Session)session);
                        executionManager.execute((ICommand)new AbstractReadWriteCommand(){

                            public void run() {
                                if (AbstractFixDiagramsHandler.this.getFixHelper() instanceof FixCustomFeaturesHelper) {
                                    modifiedDiagrams.addAll(((FixCustomFeaturesHelper)AbstractFixDiagramsHandler.this.getFixHelper()).fixDiagram(session));
                                }
                                if (AbstractFixDiagramsHandler.this.getFixHelper() instanceof FixDAnnotationsHelper) {
                                    modifiedDiagrams.addAll(((FixDAnnotationsHelper)AbstractFixDiagramsHandler.this.getFixHelper()).fixDiagramEventuallyClean(session, checked[0]));
                                }
                            }
                        });
                        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
                        for (DRepresentation dRepresentation : modifiedDiagrams) {
                            RefreshActionListenerRegistry.INSTANCE.notifyRepresentationIsAboutToBeRefreshed(dRepresentation);
                        }
                        domain.getCommandStack().execute((Command)new RefreshRepresentationsCommand(domain, (IProgressMonitor)new SubProgressMonitor(monitor, 1), modifiedDiagrams));
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(40);
                job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().createRule((IResource)airdFile.getProject().getWorkspace().getRoot()));
                job.setUser(true);
                job.schedule();
            }
        };
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(false, true, operation);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getDialogConfirmationMessage() {
        return this.dialogConfirmationMessage;
    }

    public void setDialogConfirmationMessage(String dialogConfirmationMessage) {
        this.dialogConfirmationMessage = dialogConfirmationMessage;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public AbstractFixDiagramHelper getFixHelper() {
        return this.fixHelper;
    }

    public void setFixHelper(AbstractFixDiagramHelper fixHelper) {
        this.fixHelper = fixHelper;
    }

    public String getOnlyCleanMessage() {
        return this.onlyCleanMessage;
    }

    public void setOnlyCleanMessage(String onlyCleanMessage) {
        this.onlyCleanMessage = onlyCleanMessage;
    }
}

