/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.platform.sirius.ui.navigator.handlers.AbstractDiagramCommandHandler;
import org.polarsys.capella.core.platform.sirius.ui.navigator.handlers.Messages;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class RefreshDiagramsCommandHandler
extends AbstractDiagramCommandHandler {
    protected Session getSession(Object object_p) {
        Session session = null;
        if (object_p instanceof IFile) {
            session = SessionHelper.getSessionForDiagramFile((IFile)((IFile)object_p));
        } else if (object_p instanceof ModelElement) {
            session = SessionManager.INSTANCE.getSession((EObject)((ModelElement)object_p));
        }
        return session;
    }

    @Override
    public boolean isEnabled() {
        IStructuredSelection currentSelection = this.getSelection();
        if (currentSelection.isEmpty()) {
            return false;
        }
        Object selectedElement = currentSelection.getFirstElement();
        Session selectedElementSession = this.getSession(selectedElement);
        return selectedElementSession != null;
    }

    public Object execute(ExecutionEvent event_p) throws ExecutionException {
        Object selectedElement = this.getSelection().getFirstElement();
        Session session = this.getSession(selectedElement);
        Collection<Object> representationsToRefresh = Collections.emptyList();
        if (selectedElement instanceof ModelElement) {
            representationsToRefresh = new ArrayList();
            Collection allSessionRepresentations = DialectManager.INSTANCE.getAllRepresentations(session);
            for (DRepresentation representation : allSessionRepresentations) {
                EObject associatedModelElement;
                if (!(representation instanceof DSemanticDecorator) || !EcoreUtil.isAncestor((EObject)((ModelElement)selectedElement), (EObject)(associatedModelElement = ((DSemanticDecorator)representation).getTarget()))) continue;
                representationsToRefresh.add(representation);
            }
        } else if (selectedElement instanceof IFile) {
            representationsToRefresh = DialectManager.INSTANCE.getAllRepresentations(session);
        }
        if (representationsToRefresh.size() == 0) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.RefreshRepresentation_9, (String)Messages.RefreshRepresentation_10);
        } else {
            if (session.getStatus() == SessionStatus.DIRTY) {
                if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.RefreshRepresentation_4, (String)Messages.RefreshRepresentation_5)) {
                    IEditorReference[] openedEditorReferences;
                    session.save((IProgressMonitor)new NullProgressMonitor());
                    IEditorReference[] iEditorReferenceArray = openedEditorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                    int n = openedEditorReferences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference editorReference = iEditorReferenceArray[n2];
                        IEditorPart editor = editorReference.getEditor(false);
                        if (DialectUIManager.INSTANCE.canHandleEditor(editor)) {
                            DialectUIManager.INSTANCE.closeEditor(editor, false);
                        }
                        ++n2;
                    }
                } else {
                    return null;
                }
            }
            if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.RefreshRepresentation_1, (String)Messages.bind((String)Messages.RefreshRepresentation_2, (Object)representationsToRefresh.size()))) {
                final Boolean currentValueOfSiriusPrefRefreshOnOpening = SiriusEditPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusUIPreferencesKeys.PREF_REFRESH_ON_REPRESENTATION_OPENING.name());
                SiriusEditPlugin.getPlugin().getPreferenceStore().setValue(SiriusUIPreferencesKeys.PREF_REFRESH_ON_REPRESENTATION_OPENING.name(), true);
                FixDiagramsJob job = new FixDiagramsJob(Messages.RefreshRepresentation_0, representationsToRefresh, session, Display.getDefault());
                job.setUser(true);
                job.schedule();
                job.addJobChangeListener(new IJobChangeListener(){

                    public void sleeping(IJobChangeEvent event) {
                    }

                    public void scheduled(IJobChangeEvent event) {
                    }

                    public void running(IJobChangeEvent event) {
                    }

                    public void done(IJobChangeEvent event) {
                        SiriusEditPlugin.getPlugin().getPreferenceStore().setValue(SiriusUIPreferencesKeys.PREF_REFRESH_ON_REPRESENTATION_OPENING.name(), currentValueOfSiriusPrefRefreshOnOpening.booleanValue());
                    }

                    public void awake(IJobChangeEvent event) {
                    }

                    public void aboutToRun(IJobChangeEvent event) {
                    }
                });
            }
        }
        return null;
    }

    protected class ClosingDiagramJob
    extends WorkspaceJob {
        private Display _display;
        private IEditorPart editor;

        public ClosingDiagramJob(String name, IEditorPart editor_p, Display display_p) {
            super(name);
            this.editor = editor_p;
            this._display = display_p;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            this._display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchPartSite site;
                    if (ClosingDiagramJob.this.editor != null && (site = ClosingDiagramJob.this.editor.getSite()) != null && (page = site.getPage()) != null) {
                        page.closeEditor(ClosingDiagramJob.this.editor, false);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }

    protected class FixDiagramsJob
    extends WorkspaceJob {
        private Session _session;
        private Collection<DRepresentation> _representationsToRefresh;
        private Display _display;

        public FixDiagramsJob(String name, Collection<DRepresentation> representationsToRefresh_p, Session session_p, Display display_p) {
            super(name);
            this._session = session_p;
            this._representationsToRefresh = representationsToRefresh_p;
            this._display = display_p;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor_p) throws CoreException {
            monitor_p.beginTask(this.getName(), -1);
            if (this._session != null) {
                for (DRepresentation dRepresentation : this._representationsToRefresh) {
                    monitor_p.setTaskName(Messages.bind((String)Messages.RefreshRepresentation_6, (Object)dRepresentation.getName()));
                    OpeningDiagramJob job_opening = new OpeningDiagramJob(Messages.RefreshRepresentation_7, this._session, dRepresentation);
                    job_opening.setUser(false);
                    job_opening.schedule();
                    try {
                        job_opening.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (job_opening.getResult().isOK()) {
                        ClosingDiagramJob job_closing = new ClosingDiagramJob(Messages.RefreshRepresentation_8, job_opening.getCurrentEditor(), this._display);
                        job_closing.setUser(false);
                        job_closing.schedule();
                        try {
                            job_closing.join();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    monitor_p.worked(1);
                    if (monitor_p.isCanceled()) break;
                }
            }
            monitor_p.done();
            return Status.OK_STATUS;
        }
    }

    protected class OpeningDiagramJob
    extends WorkspaceJob {
        private Session _session;
        private DRepresentation _dRepresentation;
        private IEditorPart currentEditor;

        public OpeningDiagramJob(String name, Session session_p, DRepresentation dRepresentation_p) {
            super(name);
            this._session = session_p;
            this._dRepresentation = dRepresentation_p;
            this.currentEditor = null;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            if (this._session != null && this._dRepresentation != null) {
                this.currentEditor = DialectUIManager.INSTANCE.openEditor(this._session, this._dRepresentation, monitor);
            }
            return Status.OK_STATUS;
        }

        public IEditorPart getCurrentEditor() {
            return this.currentEditor;
        }
    }
}

