/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.viewpoint.Customizable;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.handlers.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.helpers.AbstractFixDiagramHelper;

public class FixCustomFeaturesHelper
extends AbstractFixDiagramHelper {
    private static final RGBValues LIGHT_ORANGE_RC = FixCustomFeaturesHelper.createRGBValues(252, 233, 79);
    private static final RGBValues DARK_ORANGE_RC = FixCustomFeaturesHelper.createRGBValues(252, 175, 62);
    private static final RGBValues LIGHT_GREEN_RC = FixCustomFeaturesHelper.createRGBValues(204, 242, 166);
    private static final RGBValues DARK_GREEN_RC = FixCustomFeaturesHelper.createRGBValues(138, 226, 52);
    private static final RGBValues LIGHT_BLUE_RC = FixCustomFeaturesHelper.createRGBValues(194, 239, 255);
    private static final RGBValues DARK_BLUE_RC = FixCustomFeaturesHelper.createRGBValues(114, 159, 207);
    private static final RGBValues LIGHT_ORANGE_0_8 = FixCustomFeaturesHelper.createRGBValues(255, 255, 255);
    private static final RGBValues DARK_ORANGE_0_8 = FixCustomFeaturesHelper.createRGBValues(247, 218, 116);
    private static final RGBValues LIGHT_GREEN_0_8 = FixCustomFeaturesHelper.createRGBValues(255, 255, 255);
    private static final RGBValues DARK_GREEN_0_8 = FixCustomFeaturesHelper.createRGBValues(222, 255, 204);
    private static final RGBValues LIGHT_BLUE_0_8 = FixCustomFeaturesHelper.createRGBValues(255, 255, 255);
    private static final RGBValues DARK_BLUE_0_8 = FixCustomFeaturesHelper.createRGBValues(198, 230, 255);

    public FixCustomFeaturesHelper() {
        this.setLogPrefix(Messages.FixCustomFeaturesJobName);
    }

    @Override
    protected Map<DRepresentation, Integer> doFixDiagrams(Resource resource) {
        HashMap<DRepresentation, Integer> diagramToModifiedObjectCount = new HashMap<DRepresentation, Integer>();
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            Square square;
            RGBValues color;
            EObject obj = (EObject)it.next();
            if (this.isStyleWithCustomForegroundBackground(obj)) {
                FlatContainerStyle style = (FlatContainerStyle)obj;
                RGBValues backgroundColor = style.getBackgroundColor();
                RGBValues foregroundColor = style.getForegroundColor();
                if (!(this.isExpectedColor(LIGHT_GREEN_RC, backgroundColor) && this.isExpectedColor(DARK_GREEN_RC, foregroundColor) || this.isExpectedColor(LIGHT_ORANGE_RC, backgroundColor) && this.isExpectedColor(DARK_ORANGE_RC, foregroundColor) || this.isExpectedColor(LIGHT_BLUE_RC, backgroundColor) && this.isExpectedColor(DARK_BLUE_RC, foregroundColor) || this.isExpectedColor(LIGHT_GREEN_0_8, backgroundColor) && this.isExpectedColor(DARK_GREEN_0_8, foregroundColor) || this.isExpectedColor(LIGHT_ORANGE_0_8, backgroundColor) && this.isExpectedColor(DARK_ORANGE_0_8, foregroundColor)) && (!this.isExpectedColor(LIGHT_BLUE_0_8, backgroundColor) || !this.isExpectedColor(DARK_BLUE_0_8, foregroundColor))) continue;
                this.retainBorderColorAndBorderSize((Customizable)style, diagramToModifiedObjectCount);
                continue;
            }
            if (!this.isSquareWithCustomColor(obj) || !this.isExpectedColor(DARK_GREEN_RC, color = (square = (Square)obj).getColor()) && !this.isExpectedColor(DARK_ORANGE_RC, color) && !this.isExpectedColor(DARK_BLUE_RC, color) && !this.isExpectedColor(DARK_GREEN_0_8, color) && !this.isExpectedColor(DARK_ORANGE_0_8, color) && !this.isExpectedColor(DARK_BLUE_0_8, color)) continue;
            this.retainBorderColorAndBorderSize((Customizable)square, diagramToModifiedObjectCount);
        }
        return diagramToModifiedObjectCount;
    }

    private void retainBorderColorAndBorderSize(Customizable customizable, Map<DRepresentation, Integer> diagramToModifiedObjectCount) {
        DDiagramElement dDiagramElement = (DDiagramElement)customizable.eContainer();
        DDiagram diagram = DiagramHelper.getService().getDiagramContainer((EObject)dDiagramElement);
        this.logInfo("Removing custom features from: " + dDiagramElement.getName() + " in diagram: " + diagram.getName());
        ArrayList<String> toRetain = new ArrayList<String>();
        toRetain.add(DiagramPackage.Literals.BORDERED_STYLE__BORDER_COLOR.getName());
        toRetain.add(DiagramPackage.Literals.BORDERED_STYLE__BORDER_SIZE.getName());
        customizable.getCustomFeatures().retainAll(toRetain);
        Integer count = diagramToModifiedObjectCount.get(diagram);
        if (count != null) {
            count = count + 1;
            diagramToModifiedObjectCount.put((DRepresentation)diagram, count);
        } else {
            diagramToModifiedObjectCount.put((DRepresentation)diagram, 1);
        }
    }

    private boolean isSquareWithCustomColor(EObject candidate) {
        return candidate instanceof Square && ((Square)candidate).getCustomFeatures().contains((Object)DiagramPackage.Literals.SQUARE__COLOR.getName()) && candidate.eContainer() instanceof DNode && ((DNode)candidate.eContainer()).getTarget() instanceof AbstractFunction;
    }

    private boolean isStyleWithCustomForegroundBackground(EObject candidate) {
        return candidate instanceof FlatContainerStyle && ((FlatContainerStyle)candidate).getCustomFeatures().contains((Object)DiagramPackage.Literals.FLAT_CONTAINER_STYLE__FOREGROUND_COLOR.getName()) && ((FlatContainerStyle)candidate).getCustomFeatures().contains((Object)DiagramPackage.Literals.FLAT_CONTAINER_STYLE__BACKGROUND_COLOR.getName()) && candidate.eContainer() instanceof DNodeContainer && ((DNodeContainer)candidate.eContainer()).getTarget() instanceof AbstractFunction;
    }

    private boolean isExpectedColor(RGBValues expectedColor, RGBValues actualColor) {
        return actualColor != null && expectedColor.getRed() == actualColor.getRed() && expectedColor.getGreen() == actualColor.getGreen() && expectedColor.getBlue() == actualColor.getBlue();
    }

    private static RGBValues createRGBValues(int red, int green, int blue) {
        return RGBValues.create((int)red, (int)green, (int)blue);
    }
}

