/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.refresh;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.tools.api.part.DiagramEditPartService;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.core.platform.sirius.ui.navigator.refresh.Messages;

public final class SpecificRefreshCommand
extends RecordingCommand {
    protected final Session _session;
    private final Collection<DRepresentation> _representationsToRefresh;
    protected Collection<Object> impactedElements = new LinkedHashSet<Object>();
    private Collection<DRepresentation> modifiedRepresentations = new LinkedHashSet<DRepresentation>();
    private ModificationListener modificationListener;
    private IProgressMonitor _monitor;
    private Display _display;

    private void reInitImpactedElements() {
        this.impactedElements.clear();
        this.impactedElements = new LinkedHashSet<Object>();
    }

    public SpecificRefreshCommand(Session session_p, Collection<DRepresentation> representationsToRefresh_p, IProgressMonitor monitor_p, Display display_p) {
        super(session_p.getTransactionalEditingDomain(), Messages.SpecificRefreshCommand_0);
        this._session = session_p;
        this._representationsToRefresh = representationsToRefresh_p;
        this.modificationListener = new ModificationListener();
        this._monitor = monitor_p;
        this._display = display_p;
    }

    public static Collection<DRepresentation> refreshRepresentations(Session session_p, Collection<DRepresentation> representationsToRefresh_p, IProgressMonitor monitor_p, Display display_p) {
        LinkedHashSet<DRepresentation> modifiedRepresentations = new LinkedHashSet<DRepresentation>();
        SpecificRefreshCommand refreshCommand = new SpecificRefreshCommand(session_p, representationsToRefresh_p, monitor_p, display_p);
        if (session_p != null) {
            session_p.getTransactionalEditingDomain().getCommandStack().execute((Command)refreshCommand);
            modifiedRepresentations.addAll(refreshCommand.getModifiedRepresentations());
        }
        return modifiedRepresentations;
    }

    protected void doExecute() {
        for (DRepresentation representation : this._representationsToRefresh) {
            if (!DialectManager.INSTANCE.canRefresh(representation)) continue;
            this.modificationListener.activate(representation);
            DialectManager.INSTANCE.refresh(representation, this._monitor);
            this.modificationListener.deactivate(representation);
        }
        this.populateModifiedRepresentations();
        this._display.asyncExec(new Runnable(){

            @Override
            public void run() {
                SpecificRefreshCommand.this._session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(SpecificRefreshCommand.this._session.getTransactionalEditingDomain()){

                    protected void doExecute() {
                        SpecificRefreshCommand.this.synchronizeAndLayoutGMFModels();
                    }
                });
            }
        });
    }

    public Collection<?> getAffectedObjects() {
        return this.getModifiedRepresentations();
    }

    public Collection<DRepresentation> getModifiedRepresentations() {
        return Collections.unmodifiableCollection(this.modifiedRepresentations);
    }

    public Collection<?> getResult() {
        return this.getModifiedRepresentations();
    }

    private void populateModifiedRepresentations() {
        for (Object obj : this.impactedElements) {
            EObject eobject;
            DRepresentation rep;
            if (!(obj instanceof EObject) || (rep = this.getModifiedRepresentation(eobject = (EObject)obj)) == null) continue;
            this.modifiedRepresentations.add(rep);
        }
        this.reInitImpactedElements();
    }

    private DRepresentation getModifiedRepresentation(EObject eobject) {
        DRepresentation rep = null;
        if (eobject instanceof DRepresentation) {
            rep = (DRepresentation)eobject;
        } else {
            EObjectQuery query = new EObjectQuery(eobject);
            Option firstAncestorOfType = query.getFirstAncestorOfType(ViewpointPackage.eINSTANCE.getDRepresentation());
            if (firstAncestorOfType.some() && firstAncestorOfType.get() instanceof DRepresentation) {
                rep = (DRepresentation)firstAncestorOfType.get();
            }
        }
        return rep;
    }

    private void synchronizeAndLayoutGMFModels() {
        LinkedHashSet<Diagram> diagsToRefreshLayout = new LinkedHashSet<Diagram>();
        for (DRepresentation rep : this.modifiedRepresentations) {
            if (!(rep instanceof DDiagram)) continue;
            DDiagram diag = (DDiagram)rep;
            Diagram gmfDiagram = SiriusGMFHelper.getGmfDiagram((DDiagram)diag, (Session)this._session);
            CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(gmfDiagram);
            canonicalSynchronizer.synchronize();
            diagsToRefreshLayout.add(gmfDiagram);
        }
        this.layoutModifiedGMFDiagrams(diagsToRefreshLayout);
    }

    private void layoutModifiedGMFDiagrams(Collection<Diagram> diagsToRefreshLayout) {
        final Shell shell = new Shell();
        DiagramEditPartService service = new DiagramEditPartService();
        for (Diagram gmfDiagram : diagsToRefreshLayout) {
            DiagramEditPart diagramEditPart = service.createDiagramEditPart(gmfDiagram, shell, PreferencesHint.USE_DEFAULTS);
            if (diagramEditPart == null) continue;
            service.arrangeCreatedViews(diagramEditPart);
            diagramEditPart.deactivate();
        }
        this._display.asyncExec(new Runnable(){

            @Override
            public void run() {
                shell.dispose();
            }
        });
    }

    private final class ModificationListener
    extends EContentAdapter {
        private boolean activated;

        public void activate(DRepresentation representation) {
            if (representation != null) {
                representation.eAdapters().add((Object)this);
                this.activated = true;
            }
        }

        public void deactivate(DRepresentation representation) {
            this.activated = false;
            if (representation != null) {
                representation.eAdapters().remove((Object)this);
            }
        }

        public void notifyChanged(Notification notification) {
            if (this.activated && !notification.isTouch()) {
                switch (notification.getEventType()) {
                    case 1: 
                    case 3: 
                    case 5: {
                        SpecificRefreshCommand.this.impactedElements.add(notification.getNotifier());
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: 
                    case 7: {
                        SpecificRefreshCommand.this.impactedElements.add(notification.getNotifier());
                        break;
                    }
                }
            }
            super.notifyChanged(notification);
        }
    }
}

