/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.viewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.common.ui.tools.api.navigator.GroupingContentProvider;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointItem;
import org.eclipse.sirius.ui.tools.internal.views.common.SessionWrapperContentProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.ui.navigator.SaveablesProvider;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.ModelInformation;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.platform.sirius.ted.SemanticCrossReferencer;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.ui.toolkit.provider.GroupedAdapterFactoryContentProvider;
import org.polarsys.capella.core.commands.preferences.service.AbstractPreferencesInitializer;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.model.helpers.ProjectExt;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.ActiveSessionManager;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.CapellaSaveablesProvider;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.NavigatorEditingDomainDispatcher;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.kitalpha.ad.metadata.helpers.MetadataHelper;

public class CapellaNavigatorContentProvider
extends GroupedAdapterFactoryContentProvider
implements IResourceChangeListener,
IAdaptable {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    public static final String CONTENT_EXTENSION_ID = "capella.project.explorer.content";
    private static final Object[] NO_CHILD = new Object[0];
    private ITreeContentProvider _sessionContentProvider;
    private CapellaSaveablesProvider _saveablesProvider;

    public Object getAdapter(Class clazz) {
        if (SaveablesProvider.class == clazz) {
            return this._saveablesProvider;
        }
        return null;
    }

    public CapellaNavigatorContentProvider() {
        super(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 4);
        CustomizedSessionWrapperContentProvider customizedSessionWrapperContentProvider = new CustomizedSessionWrapperContentProvider((ITreeContentProvider)new AdapterFactoryContentProvider(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory()));
        SiriusTransPlugin.getPlugin().getPreferenceStore().setValue("GROUP_BY_CONTAINING_FEATURE", true);
        this._sessionContentProvider = new GroupingContentProvider((ITreeContentProvider)customizedSessionWrapperContentProvider);
        if (this._saveablesProvider == null) {
            this._saveablesProvider = new CapellaSaveablesProvider();
        }
        NavigatorEditingDomainDispatcher.registerNotifyChangedListener((INotifyChangedListener)this);
        ActiveSessionManager.getInstance().enableContentNotifications();
    }

    public ITreeContentProvider getSessionContentProvider() {
        return this._sessionContentProvider;
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            parent = resource.getParent();
        } else if (element instanceof DAnalysisSession) {
            parent = SessionHelper.getFirstAnalysisFile((DAnalysisSession)((DAnalysisSession)element));
        } else if (element instanceof DSemanticDecorator) {
            DSemanticDecorator representation = (DSemanticDecorator)element;
            parent = representation.getTarget();
        } else if (CapellaResourceHelper.isCapellaResource((Object)element)) {
            Session session = SessionManager.INSTANCE.getSession((Resource)element);
            parent = this.getParent(session);
        } else if (element instanceof Project) {
            Resource mmResource = ((EObject)element).eResource();
            parent = this.getParent(mmResource);
        } else if (element instanceof SystemEngineering && !this.isCapellaProjectDisplayed((EObject)ProjectExt.getProject((EObject)((EObject)element)))) {
            Resource mmResource = ((EObject)element).eResource();
            parent = this.getParent(mmResource);
        } else if (element instanceof SystemEngineering && this.isCapellaProjectDisplayed((EObject)ProjectExt.getProject((EObject)((EObject)element)))) {
            parent = this._sessionContentProvider.getParent(element);
        } else if (element instanceof EObject && ((EObject)element).eContainer() instanceof Component) {
            EObject eObject = (EObject)element;
            Component component = (Component)eObject.eContainer();
            if (this.isImplicitView(component) && component.eContainingFeature().equals(CsPackage.Literals.PART__OWNED_ABSTRACT_TYPE)) {
                return this.getParent(component);
            }
            parent = this._sessionContentProvider.getParent(element);
        } else {
            parent = this._sessionContentProvider.getParent(element);
        }
        return parent;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getChildren(Object element) {
        Object[] result = NO_CHILD;
        try {
            if (element instanceof IProject) {
                result = this.getIProjectChildren((IProject)element);
            } else if (element instanceof IFile) {
                IFile file = (IFile)element;
                if ("aird".equals(file.getFileExtension())) {
                    result = this.getAirdFileChildren(file);
                }
            } else {
                if (element instanceof Session) {
                    Session session = (Session)element;
                    TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
                    IModel referencingModel = ILibraryManager.INSTANCE.getModel(session.getTransactionalEditingDomain());
                    if (referencingModel != null) {
                        LinkedList<Project> rootProject = new LinkedList<Project>();
                        LinkedList<Project> libraries = new LinkedList<Project>();
                        LinkedList<Object> others = new LinkedList<Object>();
                        HashSet<Resource> resourcesDone = new HashSet<Resource>();
                        if (referencingModel instanceof CapellaModel) {
                            Project object = ((CapellaModel)referencingModel).getProject(domain);
                            if (object != null) {
                                rootProject.add(object);
                            }
                            resourcesDone.add(object.eResource());
                        }
                        Collection allReferenced = LibraryManagerExt.getAllReferences((IModel)referencingModel);
                        for (IModel referenced : allReferenced) {
                            Project object;
                            if (!(referenced instanceof CapellaModel) || (object = ((CapellaModel)referenced).getProject(domain)) == null) continue;
                            resourcesDone.add(object.eResource());
                            if (!referencingModel.isActive(referenced)) continue;
                            libraries.add(object);
                        }
                        Object[] objectArray = this._sessionContentProvider.getChildren(element);
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object child = objectArray[n2];
                            if (child instanceof Resource && !resourcesDone.contains(child) && !((Resource)child).getContents().isEmpty()) {
                                Resource childResource = (Resource)child;
                                if (CapellaResourceHelper.isCapellaResource((Object)child)) {
                                    if (!CapellaResourceHelper.isCapellaFragment((URI)childResource.getURI())) {
                                        for (EObject object : childResource.getContents()) {
                                            IModel referencedLibrary = ILibraryManager.INSTANCE.getModel(object);
                                            if (referencedLibrary != null) continue;
                                            others.addFirst(object);
                                        }
                                    }
                                } else if (!MetadataHelper.isMetadataResource((Resource)childResource)) {
                                    others.addFirst(childResource.getContents());
                                }
                            } else {
                                others.addLast(child);
                            }
                            ++n2;
                        }
                        LinkedList<Object> resultList = new LinkedList<Object>();
                        resultList.addAll(rootProject);
                        resultList.addAll(libraries);
                        resultList.addAll(others);
                        return resultList.toArray();
                    }
                    return this._sessionContentProvider.getChildren(element);
                }
                if (element instanceof Part && this.isImplicitView(element) && ((Part)element).getOwnedAbstractType() != null) {
                    ArrayList<Object> merged = new ArrayList<Object>();
                    merged.addAll(Arrays.asList(this._sessionContentProvider.getChildren(element)));
                    merged.addAll(Arrays.asList(this.getChildren(((Part)element).getOwnedAbstractType())));
                    merged.remove(((Part)element).getOwnedAbstractType());
                    return merged.toArray();
                }
                result = this._sessionContentProvider.getChildren(element);
            }
        }
        catch (Exception e) {
            Logger.getLogger((String)"User Interface").error((Object)("Error when retrieving children of " + element), (Throwable)e);
        }
        return result;
    }

    protected boolean isImplicitView(Object part) {
        boolean explicit = AbstractPreferencesInitializer.getBoolean((String)"preference.show.part.explicit", (boolean)true);
        return !explicit;
    }

    @Deprecated
    protected boolean isCapellaProjectDisplayed() {
        return AbstractPreferencesInitializer.getBoolean((String)"preference.show.capella.project.concept", (boolean)false);
    }

    protected boolean isCapellaProjectDisplayed(EObject contentChild) {
        if (contentChild instanceof Project) {
            return AbstractPreferencesInitializer.getBoolean((String)"preference.show.capella.project.concept", (Object)contentChild);
        }
        return this.isCapellaProjectDisplayed();
    }

    protected Object[] getAirdFileChildren(IFile file) {
        Object[] result = NO_CHILD;
        Session session = SessionHelper.getSession((IFile)file);
        if (session != null) {
            Object[] children;
            ArrayList<Object> retainedChildren = new ArrayList<Object>(0);
            Object[] objectArray = children = this.getChildren(session);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof Project) {
                    boolean isCapellaProjectHidden;
                    Project project = (Project)object;
                    boolean bl = isCapellaProjectHidden = !this.isCapellaProjectDisplayed((EObject)project);
                    if (isCapellaProjectHidden) {
                        this.adapterFactory.adapt((Notifier)project, IEditingDomainItemProvider.class);
                        retainedChildren.addAll((Collection<Object>)project.getOwnedModelRoots());
                    } else {
                        retainedChildren.add(project);
                    }
                } else {
                    retainedChildren.add(object);
                }
                ++n2;
            }
            result = retainedChildren.toArray();
        }
        return result;
    }

    protected Object[] getIProjectChildren(IProject project) {
        Object[] result = NO_CHILD;
        try {
            if (project.isOpen()) {
                result = project.members();
            }
        }
        catch (CoreException exception) {
            StringBuilder loggerMessage = new StringBuilder("CapellaNavigatorContentProvider.getChildren(..) _ ");
            loggerMessage.append(exception.getMessage());
            __logger.warn((Object)new EmbeddedMessage(loggerMessage.toString(), "User Interface"), (Throwable)exception);
        }
        return result;
    }

    public void dispose() {
        NavigatorEditingDomainDispatcher.unregisterNotifyChangedListener((INotifyChangedListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this._sessionContentProvider != null) {
            this._sessionContentProvider.dispose();
            this._sessionContentProvider = null;
        }
        super.dispose();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 4: {
                Object[] children;
                if (event.getResource() == null) break;
                IProject project = (IProject)event.getResource();
                Object[] objectArray = children = this.getChildren(project);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof Session) {
                        Session session = (Session)object;
                        IEditingSession sessionUI = SessionUIManager.INSTANCE.getUISession(session);
                        boolean saveSession = false;
                        if (SessionStatus.DIRTY.equals((Object)session.getStatus())) {
                            saveSession = SWTUtil.showSaveDialog((Object)session, (String)"Session", (boolean)true) == 0;
                        }
                        sessionUI.close(saveSession);
                    }
                    ++n2;
                }
                break;
            }
        }
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        boolean shouldNotify = true;
        if (notifier instanceof DRepresentation && !(notifier instanceof DSemanticDiagram)) {
            shouldNotify = false;
        }
        if (shouldNotify) {
            SemanticCrossReferencer crossReferencer;
            SemanticEditingDomainFactory.SemanticEditingDomain editingDomain;
            IFile file;
            Resource sessionResource;
            Session session;
            TransactionalEditingDomain domain;
            Notification localNotification = notification;
            if (notifier instanceof EObject && (domain = TransactionHelper.getEditingDomain((EObject)((EObject)notifier))) != null) {
                domain.addResourceSetListener(this.getListener());
                if (!ActiveSessionManager.getInstance().isEnabledContentNotifications(domain)) {
                    return;
                }
            }
            if (notifier instanceof ModelInformation && (session = SessionManager.INSTANCE.getSession((EObject)((ModelInformation)notifier))) != null && (sessionResource = session.getSessionResource()) != null && (file = EcoreUtil2.getFile((Resource)session.getSessionResource())) != null) {
                localNotification = new ViewerNotification(localNotification, (Object)file);
            }
            if (notifier instanceof Project && !this.isCapellaProjectDisplayed((EObject)notifier)) {
                localNotification = new ViewerNotification(localNotification, (Object)((EObject)notifier).eContainer());
            }
            if (notifier instanceof Component && ((EObject)notifier).eContainer() instanceof Part && this.isImplicitView(notifier)) {
                localNotification = new ViewerNotification(localNotification, (Object)((EObject)notifier).eContainer());
            }
            if (notifier instanceof DRepresentationDescriptor && notification.getFeature() == ViewpointPackage.Literals.DREPRESENTATION_DESCRIPTOR__TARGET) {
                localNotification = new ViewerNotification(notification, notification.getOldValue(), true, true);
                super.notifyChanged(localNotification);
                localNotification = new ViewerNotification(notification, notification.getNewValue(), true, true);
            }
            super.notifyChanged(localNotification);
            if (ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME.equals(localNotification.getFeature()) && (editingDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)TransactionHelper.getEditingDomain((EObject)((EObject)notifier))) != null && (crossReferencer = editingDomain.getCrossReferencer()) != null) {
                Collection referencingObjectSettings = crossReferencer.getInverseReferences((EObject)notifier);
                for (EStructuralFeature.Setting setting : referencingObjectSettings) {
                    super.addObject(setting.getEObject());
                }
            }
        }
    }

    class CustomizedSessionWrapperContentProvider
    extends SessionWrapperContentProvider {
        public CustomizedSessionWrapperContentProvider(ITreeContentProvider wrapped) {
            super(wrapped);
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = super.getChildren(parentElement);
            if (parentElement instanceof ViewpointItem) {
                ArrayList<Object> selectedChildren = new ArrayList<Object>(0);
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (child instanceof RepresentationDescriptionItem && !((RepresentationDescriptionItem)child).getChildren().isEmpty()) {
                        selectedChildren.add(child);
                    }
                    ++n2;
                }
                children = selectedChildren.toArray();
            }
            return children;
        }
    }
}

