/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.viewer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.ui.business.internal.session.SessionSaveable;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IJobRunnable;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.ActiveSessionManager;
import org.polarsys.capella.core.sirius.ui.SaveSessionAction;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class CapellaSaveable
extends SessionSaveable {
    private Cursor waitCursor;
    private Cursor originalCursor;

    public CapellaSaveable(Session session) {
        super(session);
    }

    public Object getAdapter(Class adapter) {
        if (Session.class == adapter) {
            return this.getSession();
        }
        return super.getAdapter(adapter);
    }

    public IJobRunnable doSave(IProgressMonitor monitor, IShellProvider shellProvider) throws CoreException {
        SaveSessionAction saveSessionAction = new SaveSessionAction();
        saveSessionAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getSession()));
        saveSessionAction.run();
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        SaveSessionAction saveSessionAction = new SaveSessionAction();
        saveSessionAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getSession()));
        saveSessionAction.run();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof SessionSaveable) {
            SessionSaveable saveable = (SessionSaveable)object;
            result = this.getSession() == saveable.getSession();
        }
        return result;
    }

    public int hashCode() {
        return this.getSession().hashCode();
    }

    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor result = null;
        IFile analysisFile = SessionHelper.getFirstAnalysisFile((DAnalysisSession)((DAnalysisSession)this.getSession()));
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)analysisFile.getAdapter(IWorkbenchAdapter.class);
        if (workbenchAdapter != null) {
            result = workbenchAdapter.getImageDescriptor((Object)analysisFile);
        }
        return result;
    }

    public String getName() {
        String result = "";
        IFile analysisFile = SessionHelper.getFirstAnalysisFile((DAnalysisSession)((DAnalysisSession)this.getSession()));
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)analysisFile.getAdapter(IWorkbenchAdapter.class);
        result = workbenchAdapter != null ? workbenchAdapter.getLabel((Object)analysisFile) : analysisFile.getFullPath().toString();
        return result;
    }

    public String getToolTipText() {
        return null;
    }

    public boolean isDirty() {
        Session currentSession;
        if (ActiveSessionManager.getInstance().isEnabledContentNotifications(this.getSession().getTransactionalEditingDomain()) && (currentSession = this.getSession()) != null && SessionManager.INSTANCE.getSessions().contains(currentSession)) {
            return SessionStatus.DIRTY.equals((Object)this.getSession().getStatus());
        }
        return false;
    }

    public void disableUI(IWorkbenchPart[] parts, boolean closing) {
        int i = 0;
        while (i < parts.length) {
            IWorkbenchPart workbenchPart = parts[i];
            Composite paneComposite = (Composite)((PartSite)workbenchPart.getSite()).getModel().getWidget();
            Control[] paneChildren = paneComposite.getChildren();
            Composite toDisable = (Composite)paneChildren[0];
            toDisable.setEnabled(false);
            if (this.waitCursor == null) {
                this.waitCursor = workbenchPart.getSite().getWorkbenchWindow().getShell().getDisplay().getSystemCursor(1);
            }
            if (this.waitCursor.equals((Object)paneComposite.getCursor())) {
                this.originalCursor = paneComposite.getCursor();
                paneComposite.setCursor(this.waitCursor);
            }
            ++i;
        }
    }

    public void enableUI(IWorkbenchPart[] parts) {
        int i = 0;
        while (i < parts.length) {
            IWorkbenchPart workbenchPart = parts[i];
            Composite paneComposite = (Composite)((PartSite)workbenchPart.getSite()).getModel().getWidget();
            Control[] paneChildren = paneComposite.getChildren();
            Composite toEnable = (Composite)paneChildren[0];
            paneComposite.setCursor(this.originalCursor);
            if (this.waitCursor != null) {
                this.waitCursor = null;
            }
            toEnable.setEnabled(true);
            ++i;
        }
    }
}

