/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.preferences.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.cs.AbstractPathInvolvedElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.ConstraintDuration;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.ExecutionEnd;
import org.polarsys.capella.core.data.interaction.FragmentEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.InteractionState;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.model.handler.command.PreDeleteHandler;
import org.polarsys.capella.core.model.handler.command.PreDeleteStructureCommand;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;

class DeleteHelper {
    DeleteHelper() {
    }

    private static void addElementsForAssociation(Collection<Object> elementsToDelete) {
        ArrayList elementToAdd = new ArrayList(0);
        for (Object elementToDelete : elementsToDelete) {
            if (!(elementToDelete instanceof Association)) continue;
            elementToAdd.addAll(((Association)elementToDelete).getNavigableMembers());
        }
        if (!elementToAdd.isEmpty()) {
            elementsToDelete.addAll(elementToAdd);
        }
    }

    private static void addElementsForFunctionalChainInvolvement(Collection<Object> elementsToDelete) {
        ArrayList elementToAdd = new ArrayList(0);
        for (Object elementToDelete : elementsToDelete) {
            FunctionalChainInvolvement fcInvolvement;
            InvolvedElement involved;
            if (!(elementToDelete instanceof FunctionalChainInvolvement) || (involved = (fcInvolvement = (FunctionalChainInvolvement)elementToDelete).getInvolved()) == null || !(involved instanceof AbstractFunction)) continue;
            elementToAdd.addAll(fcInvolvement.getNextFunctionalChainInvolvements());
            elementToAdd.addAll(fcInvolvement.getPreviousFunctionalChainInvolvements());
        }
        if (!elementToAdd.isEmpty()) {
            elementsToDelete.addAll(elementToAdd);
        }
    }

    private static void addElementsForPhysicalPathInvolvement(Collection<Object> elementsToDelete) {
        ArrayList elementToAdd = new ArrayList(0);
        for (Object elementToDelete : elementsToDelete) {
            PhysicalPathInvolvement pathInvolvement;
            AbstractPathInvolvedElement involved;
            if (!(elementToDelete instanceof PhysicalPathInvolvement) || (involved = (pathInvolvement = (PhysicalPathInvolvement)elementToDelete).getInvolvedElement()) == null || !(involved instanceof Part)) continue;
            elementToAdd.addAll(pathInvolvement.getNextInvolvements());
            elementToAdd.addAll(pathInvolvement.getPreviousInvolvements());
        }
        if (!elementToAdd.isEmpty()) {
            elementsToDelete.addAll(elementToAdd);
        }
    }

    public static void addInAdditionSomeReferencedElemensInDelete(Collection<Object> elementsToDelete) {
        DeleteHelper.addElementsForPhysicalPathInvolvement(elementsToDelete);
        DeleteHelper.addElementsForAbstractState(elementsToDelete);
        DeleteHelper.addElementsForAbstractFunction(elementsToDelete);
        DeleteHelper.addElementsForFunctionalChainInvolvement(elementsToDelete);
        DeleteHelper.addElementsForAssociation(elementsToDelete);
        DeleteHelper.globalizeElementsForScenario(elementsToDelete);
        DeleteHelper.addPendingPropertyValues(elementsToDelete);
        DeleteHelper.addPendingPropertyValueGroups(elementsToDelete);
    }

    private static void addElementsForAbstractFunction(Collection<Object> elementsToDelete) {
        ArrayList elementsToAdd = new ArrayList();
        for (Object elementToDelete : elementsToDelete) {
            if (!(elementToDelete instanceof AbstractFunction)) continue;
            elementsToAdd.addAll(EObjectExt.getReferencers((EObject)((EObject)elementToDelete), (EReference)InteractionPackage.Literals.STATE_FRAGMENT__RELATED_ABSTRACT_FUNCTION));
        }
        elementsToDelete.addAll(elementsToAdd);
    }

    private static void addElementsForAbstractState(Collection<Object> elementsToDelete) {
        ArrayList elementsToAdd = new ArrayList();
        for (Object elementToDelete : elementsToDelete) {
            if (!(elementToDelete instanceof AbstractState)) continue;
            elementsToAdd.addAll(EObjectExt.getReferencers((EObject)((EObject)elementToDelete), (EReference)InteractionPackage.Literals.STATE_FRAGMENT__RELATED_ABSTRACT_STATE));
        }
        elementsToDelete.addAll(elementsToAdd);
    }

    private static void addPendingPropertyValues(Collection<Object> elementsToDelete) {
        HashSet<Object> propertyValuesToAddToDeletedElements = new HashSet<Object>(0);
        for (Object object : elementsToDelete) {
            if (!(object instanceof CapellaElement)) continue;
            EList appliedPropertyValues = ((CapellaElement)object).getAppliedPropertyValues();
            for (AbstractPropertyValue propertyValue : appliedPropertyValues) {
                EList valuedElements = propertyValue.getValuedElements();
                if (propertyValue == object || !propertyValue.getInvolvedElements().isEmpty() || valuedElements.size() != 1 || !valuedElements.contains(object)) continue;
                ArrayList<Object> propertyValues = new ArrayList<Object>(1);
                propertyValues.add(propertyValue);
                DeleteHelper.addPendingPropertyValues(propertyValues);
                propertyValuesToAddToDeletedElements.addAll(propertyValues);
            }
        }
        if (!propertyValuesToAddToDeletedElements.isEmpty()) {
            elementsToDelete.addAll(propertyValuesToAddToDeletedElements);
        }
    }

    private static void addPendingPropertyValueGroups(Collection<Object> elementsToDelete) {
        HashSet<Object> propertyValueGroupsToAddToDeletedElements = new HashSet<Object>(0);
        for (Object object : elementsToDelete) {
            if (!(object instanceof CapellaElement)) continue;
            EList appliedPropertyValueGroups = ((CapellaElement)object).getAppliedPropertyValueGroups();
            for (PropertyValueGroup propertyValueGroup : appliedPropertyValueGroups) {
                EList valuedElements;
                if (elementsToDelete.contains(propertyValueGroup) || (valuedElements = propertyValueGroup.getValuedElements()).size() != 1 || !valuedElements.contains(object)) continue;
                ArrayList<Object> propertyValueGroups = new ArrayList<Object>(1);
                propertyValueGroups.add(propertyValueGroup);
                DeleteHelper.addPendingPropertyValueGroups(propertyValueGroups);
                propertyValueGroupsToAddToDeletedElements.addAll(propertyValueGroups);
            }
        }
        if (!propertyValueGroupsToAddToDeletedElements.isEmpty()) {
            elementsToDelete.addAll(propertyValueGroupsToAddToDeletedElements);
        }
    }

    public static boolean computeAllDeletedElementsFor(Collection<?> elementsToDelete, HashSet<EObject> deletedElements, TransactionalEditingDomain editingDomain) {
        PreDeleteHandler handler = new PreDeleteHandler();
        boolean preferenceDeleteParts = CapellaModelPreferencesPlugin.getDefault().isDeletePartsAllowed();
        Collection<Object> eltsToDelete = elementsToDelete;
        eltsToDelete.addAll(DeleteHelper.getAdditionalElementsForParts(eltsToDelete, preferenceDeleteParts));
        DeleteHelper.addInAdditionSomeReferencedElemensInDelete(elementsToDelete);
        PreDeleteStructureCommand preDeletion = new PreDeleteStructureCommand((EditingDomain)editingDomain, elementsToDelete, preferenceDeleteParts, handler);
        if (preDeletion.canExecute()) {
            preDeletion.execute();
        }
        boolean modelModified = handler._notifications.size() > 0;
        block6: for (Notification notification : handler._notifications) {
            Object notifier = notification.getNotifier();
            if (!(notifier instanceof EObject)) continue;
            modelModified = true;
            Object oldValue = notification.getOldValue();
            int notificationType = notification.getEventType();
            switch (notificationType) {
                case 1: {
                    if (notification.getNewValue() != null) continue block6;
                }
                case 4: {
                    if (!(oldValue instanceof EObject)) break;
                    boolean handleNotification = false;
                    try {
                        EReference feature = (EReference)EReference.class.cast(notification.getFeature());
                        handleNotification = feature.isContainment();
                    }
                    catch (ClassCastException cce) {
                        handleNotification = true;
                    }
                    if (!handleNotification) break;
                    EObject deletedObject = (EObject)oldValue;
                    deletedElements.add(deletedObject);
                    if (!(deletedObject instanceof ModelElement)) break;
                    TreeIterator allChildrenOfDeletedObject = deletedObject.eAllContents();
                    while (allChildrenOfDeletedObject.hasNext()) {
                        EObject child = (EObject)allChildrenOfDeletedObject.next();
                        deletedElements.add(child);
                    }
                    continue block6;
                }
            }
        }
        handler.dispose();
        return modelModified;
    }

    public static Collection<Object> getAdditionalElementsForParts(Collection<Object> elementsToDelete, boolean preferenceDeleteParts) {
        ArrayList<Object> result = new ArrayList<Object>(0);
        for (Object elementToDelete : elementsToDelete) {
            AbstractType type;
            boolean allowMultiplePart;
            if (!(elementToDelete instanceof Part) || (allowMultiplePart = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)((Part)elementToDelete)))) && !preferenceDeleteParts || (type = ((Part)elementToDelete).getAbstractType()) == null || elementsToDelete.contains(type) || result.contains(type)) continue;
            result.add(type);
        }
        return result;
    }

    private static Collection<? extends EObject> getAllObjectsFromAbstractEnd(InteractionFragment interactionFragment) {
        ArrayList<Object> objectsToDelete = new ArrayList<Object>();
        ArrayList<Event> eventsToDelete = new ArrayList<Event>();
        if (interactionFragment instanceof MessageEnd) {
            MessageEnd messageEnd = (MessageEnd)interactionFragment;
            SequenceMessage message = messageEnd.getMessage();
            objectsToDelete.add(messageEnd);
            if (message != null) {
                objectsToDelete.add(message);
                if (message.getSendingEnd() != null && !objectsToDelete.contains(message.getSendingEnd())) {
                    objectsToDelete.add(message.getSendingEnd());
                }
                if (message.getReceivingEnd() != null && !objectsToDelete.contains(message.getReceivingEnd())) {
                    objectsToDelete.add(message.getReceivingEnd());
                }
            }
        } else if (interactionFragment instanceof ExecutionEnd) {
            ExecutionEnd executionEnd = (ExecutionEnd)interactionFragment;
            objectsToDelete.add(executionEnd);
        } else if (interactionFragment instanceof FragmentEnd) {
            objectsToDelete.add(interactionFragment);
        } else if (interactionFragment instanceof InteractionState) {
            objectsToDelete.add(interactionFragment);
        }
        for (EObject eObject : objectsToDelete) {
            AbstractEnd ae;
            if (!(eObject instanceof AbstractEnd) || (ae = (AbstractEnd)eObject).getEvent() == null) continue;
            eventsToDelete.add(ae.getEvent());
        }
        objectsToDelete.addAll(eventsToDelete);
        return objectsToDelete;
    }

    private static Collection<?> getExecutionFromScenarioElement(Collection<?> elementsToDelete) {
        ArrayList<Object> result = new ArrayList<Object>(elementsToDelete.size());
        for (Object sourceObject : elementsToDelete) {
            TimeLapse exec = null;
            Scenario s = (Scenario)((EObject)sourceObject).eContainer();
            if (sourceObject instanceof AbstractEnd) {
                for (TimeLapse exec2 : s.getOwnedTimeLapses()) {
                    if (exec2.getStart() == sourceObject) {
                        exec = exec2;
                    }
                    if (exec2.getFinish() != sourceObject) continue;
                    exec = exec2;
                }
            }
            if (sourceObject instanceof ConstraintDuration) {
                result.add((EObject)sourceObject);
            }
            if (sourceObject instanceof SequenceMessage) {
                SequenceMessage sm = (SequenceMessage)sourceObject;
                ArrayList<MessageEnd> messageEnds = new ArrayList<MessageEnd>(2);
                messageEnds.add(sm.getSendingEnd());
                messageEnds.add(sm.getReceivingEnd());
                for (TimeLapse exec2 : s.getOwnedTimeLapses()) {
                    if (messageEnds.contains(exec2.getStart())) {
                        exec = exec2;
                    }
                    if (!messageEnds.contains(exec2.getFinish())) continue;
                    exec = exec2;
                }
                if (sm.getKind() == MessageKind.CREATE || sm.getKind() == MessageKind.DELETE || sm.getSendingEnd() == null || sm.getReceivingEnd() == null) {
                    result.add(sm);
                }
            }
            if (sourceObject instanceof TimeLapse) {
                exec = (TimeLapse)sourceObject;
                result.add(exec);
            }
            if (!(sourceObject instanceof InstanceRole)) continue;
            InstanceRole ir = (InstanceRole)sourceObject;
            if (!result.contains(ir)) {
                result.add(ir);
            }
            for (TimeLapse exec2 : s.getOwnedTimeLapses()) {
                if (exec2 instanceof Execution && ((Execution)exec2).getCovered() == ir) {
                    result.add(exec2);
                }
                if (!(exec2 instanceof StateFragment) || !((StateFragment)exec2).getStart().getCoveredInstanceRoles().contains((Object)ir)) continue;
                result.add(exec2);
            }
            for (AbstractEnd ae : ir.getAbstractEnds()) {
                if (!(ae instanceof MessageEnd)) continue;
                MessageEnd me = (MessageEnd)ae;
                MessageEnd end = me.getMessage().getReceivingEnd();
                for (TimeLapse exec2 : s.getOwnedTimeLapses()) {
                    if (exec2.getStart() != end || result.contains(exec2)) continue;
                    result.add(exec2);
                }
            }
        }
        return result;
    }

    private static void globalizeElementsForScenario(Collection<Object> elementsToDelete) {
        Collection<Object> eltsToDelete = elementsToDelete;
        ArrayList<Object> sequenceElements = new ArrayList<Object>();
        ArrayList<Object> nonSequenceElements = new ArrayList<Object>();
        for (Object object : eltsToDelete) {
            if (DeleteHelper.isSequenceDiagramObject(object)) {
                sequenceElements.add(object);
                continue;
            }
            nonSequenceElements.add(object);
        }
        if (sequenceElements.size() != 0) {
            Collection<Object> executions = DeleteHelper.getExecutionFromScenarioElement(sequenceElements);
            eltsToDelete = new ArrayList<Object>();
            for (Object object : executions) {
                if (object instanceof TimeLapse) {
                    TimeLapse exec = (TimeLapse)object;
                    for (Object object2 : DeleteHelper.propagageSequenceDeletion(exec)) {
                        eltsToDelete.add(object2);
                    }
                }
                if (object instanceof ConstraintDuration) {
                    eltsToDelete.add(object);
                }
                if (object instanceof InstanceRole) {
                    eltsToDelete.add(object);
                }
                if (object instanceof SequenceMessage) {
                    SequenceMessage sm = (SequenceMessage)object;
                    if (sm.getSendingEnd() != null) {
                        eltsToDelete.add(sm.getSendingEnd());
                        eltsToDelete.add(sm.getSendingEnd().getEvent());
                    }
                    if (sm.getReceivingEnd() != null) {
                        eltsToDelete.add(sm.getReceivingEnd());
                        eltsToDelete.add(sm.getReceivingEnd().getEvent());
                    }
                    eltsToDelete.add(sm);
                    if (sm.getKind() == MessageKind.CREATE || sm.getKind() == MessageKind.DELETE) {
                        eltsToDelete.add(sm.getSendingEnd().getEvent());
                        eltsToDelete.add(sm.getReceivingEnd().getEvent());
                    }
                }
                if (!(object instanceof CombinedFragment)) continue;
                CombinedFragment cf = (CombinedFragment)object;
                eltsToDelete.addAll((Collection<Object>)cf.getReferencedOperands());
            }
        }
        ArrayList<ConstraintDuration> durationsToDelete = new ArrayList<ConstraintDuration>();
        for (Object object : eltsToDelete) {
            InteractionFragment if_;
            if (!(object instanceof InteractionFragment) || !((if_ = (InteractionFragment)object).eContainer() instanceof Scenario)) continue;
            Scenario scenario = (Scenario)if_.eContainer();
            for (ConstraintDuration duration : scenario.getOwnedConstraintDurations()) {
                if (!duration.getStart().equals(if_) && !duration.getFinish().equals(if_)) continue;
                durationsToDelete.add(duration);
            }
        }
        eltsToDelete.addAll(durationsToDelete);
        ArrayList result = new ArrayList(eltsToDelete.size());
        elementsToDelete.clear();
        elementsToDelete.addAll(nonSequenceElements);
        for (Object object : eltsToDelete) {
            if (elementsToDelete.contains(object) || object == null) continue;
            elementsToDelete.add(object);
        }
        elementsToDelete.addAll(result);
    }

    private static boolean isSequenceDiagramObject(Object elementsToDelete) {
        if (elementsToDelete instanceof InteractionState) {
            return false;
        }
        if (elementsToDelete instanceof InteractionOperand) {
            return false;
        }
        if (elementsToDelete instanceof InteractionFragment) {
            return true;
        }
        if (elementsToDelete instanceof SequenceMessage) {
            return true;
        }
        if (elementsToDelete instanceof TimeLapse) {
            return true;
        }
        if (elementsToDelete instanceof InstanceRole) {
            return true;
        }
        return elementsToDelete instanceof ConstraintDuration;
    }

    private static List<?> propagageSequenceDeletion(TimeLapse exec) {
        InteractionFragment start = exec.getStart();
        InteractionFragment finish = exec.getFinish();
        ArrayList<Object> objectsToDelete = new ArrayList<Object>();
        objectsToDelete.add(exec);
        objectsToDelete.addAll(DeleteHelper.getAllObjectsFromAbstractEnd(start));
        objectsToDelete.addAll(DeleteHelper.getAllObjectsFromAbstractEnd(finish));
        return objectsToDelete;
    }
}

