/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.ui.quickfix.resolver;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractContextMenuFiller;
import org.polarsys.capella.common.utils.graph.IDirectedGraph;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.ui.quickfix.InformationQuickFixActivator;
import org.polarsys.capella.core.data.information.ui.quickfix.messages.InformationQuickFixMessages;
import org.polarsys.capella.core.data.information.validation.class_.MDCHK_DWF_D16;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;
import org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserView;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;
import org.polarsys.capella.core.validation.ui.ide.quickfix.EObjectNavigatorDialog;

public class DWF_D16_Resolver
extends AbstractCapellaMarkerResolution {
    public void run(IMarker marker) {
        DataPkg pkg = (DataPkg)this.getModelElements(marker).get(0);
        MDCHK_DWF_D16 validator = new MDCHK_DWF_D16();
        Couple result = validator.findSCC(pkg);
        final IDirectedGraph graph = (IDirectedGraph)result.getKey();
        List sccs = (List)result.getValue();
        if (sccs == null || sccs.isEmpty()) {
            return;
        }
        EObjectNavigatorDialog dialog = new EObjectNavigatorDialog((List)sccs.iterator().next(), InformationQuickFixMessages.cycle_details_dialog_title, InformationQuickFixMessages.cycle_details_dialog_message, InformationQuickFixMessages.cycle_details_dialog_combo_lbl, InformationQuickFixMessages.cycle_details_dialog_combo_cycle_prefix);
        dialog.setCycles((Collection)sccs);
        dialog.setContextMenuManagerFiller(new AbstractContextMenuFiller(){

            public void fillMenuManager(IMenuManager contextMenuManager, final ISelection selection) {
                final LocateInCapellaExplorerAction selectInExplorerAction = new LocateInCapellaExplorerAction(){

                    protected ISelection getSelection() {
                        return selection;
                    }
                };
                Action action = new Action(){

                    public void run() {
                        selectInExplorerAction.run((IAction)this);
                    }
                };
                selectInExplorerAction.shouldIgnoreWorkbenchPartSite(true);
                action.setText(Messages.ImpactAnalysisAction_ShowInCapellaExplorer_Title);
                action.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("capella_16.png"));
                selectInExplorerAction.selectionChanged((IAction)action, selection);
                if (action.isEnabled()) {
                    contextMenuManager.add((IAction)action);
                }
                final EObject eObject = (EObject)((TreeSelection)selection).iterator().next();
                final LocateInCapellaExplorerAction selectInSemanticBrowserAction = new LocateInCapellaExplorerAction(){

                    protected ISelection getSelection() {
                        return selection;
                    }
                };
                Action action3 = new Action(){

                    public void run() {
                        try {
                            this.activateSemanticBrowser();
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                        selectInSemanticBrowserAction.run((IAction)this);
                    }

                    private void activateSemanticBrowser() throws CoreException {
                        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        SemanticBrowserView smView = (SemanticBrowserView)activePage.findView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
                        if (smView == null) {
                            smView = (SemanticBrowserView)activePage.showView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
                        }
                        activePage.activate((IWorkbenchPart)smView);
                        smView.setInput((Object)eObject);
                    }
                };
                selectInSemanticBrowserAction.shouldIgnoreWorkbenchPartSite(true);
                action3.setText(InformationQuickFixMessages.selectInSemanticBrowser);
                action3.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("capella_16.png"));
                selectInSemanticBrowserAction.selectionChanged((IAction)action3, selection);
                if (action3.isEnabled()) {
                    contextMenuManager.add((IAction)action3);
                }
                if (InformationPackage.Literals.CLASS.isSuperTypeOf(eObject.eClass())) {
                    HashSet<EObject> referencedSet = new HashSet<EObject>();
                    Iterator successors = graph.getSucessors((Object)eObject);
                    while (successors.hasNext()) {
                        referencedSet.add((EObject)successors.next());
                    }
                    if (!referencedSet.isEmpty()) {
                        for (final EObject referenced : referencedSet) {
                            final LocateInCapellaExplorerAction goToAction = new LocateInCapellaExplorerAction(){

                                protected ISelection getSelection() {
                                    return selection;
                                }

                                public void run(IAction action) {
                                    EObject elementToSelectInCapellaExplorer = referenced;
                                    if (elementToSelectInCapellaExplorer instanceof ModelElement) {
                                        this.selectElementInCapellaExplorer((ISelection)new StructuredSelection((Object)elementToSelectInCapellaExplorer));
                                    }
                                }
                            };
                            Action action2 = new Action(){

                                public void run() {
                                    goToAction.run((IAction)this);
                                }
                            };
                            ItemProviderAdapter ipa = DWF_D16_Resolver.this.getItemProvider(referenced);
                            goToAction.shouldIgnoreWorkbenchPartSite(true);
                            action2.setText(NLS.bind((String)InformationQuickFixMessages.goToReferencedElement, (Object[])new Object[]{ipa.getText((Object)referenced)}));
                            action2.setImageDescriptor(InformationQuickFixActivator.getDefault().getImageDescriptor("goto_16.png"));
                            selectInExplorerAction.selectionChanged((IAction)action2, selection);
                            if (!action2.isEnabled()) continue;
                            contextMenuManager.add((IAction)action2);
                        }
                    }
                }
            }
        });
        dialog.open();
    }

    protected String[] getResolvableRuleIds() {
        return noRuleIds;
    }

    private ItemProviderAdapter getItemProvider(EObject object) {
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)TransactionHelper.getEditingDomain((EObject)object);
        IItemLabelProvider provider = (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)object, IItemLabelProvider.class);
        return (ItemProviderAdapter)provider;
    }
}

