/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.coredomain.model.edit.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.common.utils.URIHelper;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.model.edit.helpers.AbstractHelper;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class ParentHelper
extends AbstractHelper {
    protected ParentHelper(EObject target) {
        super(target);
    }

    public static Collection<?> getCandidateResources(EObject target) {
        ParentHelper helper = new ParentHelper(target);
        HashSet<String> bundleScope = new HashSet<String>();
        IPluginModelBase model = PluginRegistry.findModel((String)helper.getProject());
        if (model == null) {
            AD_Log.getDefault().logError("Cannot find plugin related to project " + helper.getProject());
            return Collections.EMPTY_LIST;
        }
        helper.fillScope(model, bundleScope);
        Resource[] resources = ResourceReuse.createHelper().getResources(ParentHelper.createDefaultCriteria());
        return helper.filter(resources, bundleScope);
    }

    public static Collection<?> getCandidates(EObject target) {
        ParentHelper helper = new ParentHelper(target);
        HashSet<String> bundleScope = new HashSet<String>();
        IPluginModelBase model = PluginRegistry.findModel((String)helper.getProject());
        if (model == null) {
            AD_Log.getDefault().logError("Cannot find plugin related to project " + helper.getProject());
            return Collections.EMPTY_LIST;
        }
        helper.fillScope(model, bundleScope);
        Resource[] resources = ResourceReuse.createHelper().getResources(ParentHelper.createDefaultCriteria());
        Collection<Resource> filtered = helper.filter(resources, bundleScope);
        ResourceSet resourceSet = target.eResource().getResourceSet();
        ArrayList<Viewpoint> vps = new ArrayList<Viewpoint>();
        for (Resource res : filtered) {
            URI uri = URIHelper.createURI((Resource)res);
            Viewpoint vp = (Viewpoint)resourceSet.getEObject(uri, true);
            vps.add(vp);
        }
        return vps;
    }

    private Collection<Resource> filter(Resource[] resources, Set<String> bundleScope) {
        if (bundleScope == null) {
            return Arrays.asList(resources);
        }
        HashMap<String, Resource> res = new HashMap<String, Resource>();
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            if (!res.containsKey(resource.getPath()) && bundleScope.contains(resource.getProviderSymbolicName()) && !resource.getPath().contains(this.pathToExclude)) {
                res.put(resource.getPath(), resource);
            }
            ++n2;
        }
        return res.values();
    }

    protected static SearchCriteria createDefaultCriteria() {
        SearchCriteria searchCriteria = new SearchCriteria();
        searchCriteria.setDomain("AF");
        searchCriteria.getTags().add("vp");
        return searchCriteria;
    }
}

