/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.communication.properties.fields;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.properties.Messages;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticKindGroup;

public class CommunicationLinkKindGroup
extends AbstractSemanticKindGroup {
    private Button _communicationLinkBtnSend = this.createButton((Enumerator)CommunicationLinkKind.SEND);
    private Button _communicationLinkBtnReceive;
    private Button _communicationLinkBtnProduce = this.createButton((Enumerator)CommunicationLinkKind.PRODUCE);
    private Button _communicationLinkBtnConsume;
    private Button _communicationLinkBtnCall = this.createButton((Enumerator)CommunicationLinkKind.CALL);
    private Button _communicationLinkBtnExecute;
    private Button _communicationLinkBtnAccess;
    private Button _communicationLinkBtnWrite = this.createButton((Enumerator)CommunicationLinkKind.WRITE);
    private Button _communicationLinkBtnAcquire;
    private Button _communicationLinkBtnTransmit = this.createButton((Enumerator)CommunicationLinkKind.TRANSMIT);

    public CommunicationLinkKindGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, widgetFactory, Messages.getString("CommunicationLinkKind.Label"), 5);
        this._communicationLinkBtnReceive = this.createButton((Enumerator)CommunicationLinkKind.RECEIVE);
        this._communicationLinkBtnConsume = this.createButton((Enumerator)CommunicationLinkKind.CONSUME);
        this._communicationLinkBtnExecute = this.createButton((Enumerator)CommunicationLinkKind.EXECUTE);
        this._communicationLinkBtnAccess = this.createButton((Enumerator)CommunicationLinkKind.ACCESS);
        this._communicationLinkBtnAcquire = this.createButton((Enumerator)CommunicationLinkKind.ACQUIRE);
    }

    public void synchronizeKindsStatus(ExchangeMechanism exchangeMechanism) {
        if (exchangeMechanism != null) {
            switch (exchangeMechanism.getValue()) {
                case 1: {
                    this.enableFlowKinds(true);
                    this.enableEventKinds(false);
                    this.enableOperationKinds(false);
                    this.enableSharedDataKinds(false);
                    this.enableUnsetKinds(false);
                    break;
                }
                case 3: {
                    this.enableFlowKinds(false);
                    this.enableEventKinds(true);
                    this.enableOperationKinds(false);
                    this.enableSharedDataKinds(false);
                    this.enableUnsetKinds(false);
                    break;
                }
                case 2: {
                    this.enableFlowKinds(false);
                    this.enableEventKinds(false);
                    this.enableOperationKinds(true);
                    this.enableSharedDataKinds(false);
                    this.enableUnsetKinds(false);
                    break;
                }
                case 4: {
                    this.enableFlowKinds(false);
                    this.enableEventKinds(false);
                    this.enableOperationKinds(false);
                    this.enableSharedDataKinds(true);
                    this.enableUnsetKinds(false);
                    break;
                }
                case 0: {
                    this.enableFlowKinds(false);
                    this.enableEventKinds(false);
                    this.enableOperationKinds(false);
                    this.enableSharedDataKinds(false);
                    this.enableUnsetKinds(true);
                }
            }
        } else {
            this.enableFlowKinds(false);
            this.enableEventKinds(false);
            this.enableOperationKinds(false);
            this.enableSharedDataKinds(false);
            this.enableUnsetKinds(false);
        }
        this.loadData(this._semanticElement);
    }

    protected void enableFlowKinds(boolean enabled) {
        this.enableButton(this._communicationLinkBtnProduce, enabled);
        this.enableButton(this._communicationLinkBtnConsume, enabled);
    }

    protected void enableEventKinds(boolean enabled) {
        this.enableButton(this._communicationLinkBtnSend, enabled);
        this.enableButton(this._communicationLinkBtnReceive, enabled);
    }

    protected void enableOperationKinds(boolean enabled) {
        this.enableButton(this._communicationLinkBtnCall, enabled);
        this.enableButton(this._communicationLinkBtnExecute, enabled);
    }

    protected void enableSharedDataKinds(boolean enabled) {
        this.enableButton(this._communicationLinkBtnWrite, enabled);
        this.enableButton(this._communicationLinkBtnAccess, enabled);
    }

    protected void enableUnsetKinds(boolean enabled) {
        this.enableButton(this._communicationLinkBtnAcquire, enabled);
        this.enableButton(this._communicationLinkBtnTransmit, enabled);
    }

    public List<Button> getSemanticFields() {
        ArrayList<Button> fields = new ArrayList<Button>();
        fields.add(this._communicationLinkBtnProduce);
        fields.add(this._communicationLinkBtnConsume);
        fields.add(this._communicationLinkBtnSend);
        fields.add(this._communicationLinkBtnReceive);
        fields.add(this._communicationLinkBtnCall);
        fields.add(this._communicationLinkBtnExecute);
        fields.add(this._communicationLinkBtnWrite);
        fields.add(this._communicationLinkBtnAccess);
        fields.add(this._communicationLinkBtnAcquire);
        fields.add(this._communicationLinkBtnTransmit);
        return fields;
    }

    public Button getDefaultSemanticField() {
        return null;
    }
}

