/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.patterns.ui.providers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.ui.environment.DefaultModelEnvironmentUI;
import org.eclipse.emf.diffmerge.patterns.ui.environment.IModelEnvironmentUI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.ui.properties.providers.CapellaTransfertViewerLabelProvider;

public class CapellaModelEnvironmentUI
extends DefaultModelEnvironmentUI {
    private final CapellaTransfertViewerLabelProvider _capellaLP = new CapellaTransfertViewerLabelProvider();

    public ViewerSorter getSorter(IModelEnvironmentUI.SortingMethod method) {
        NameTypeArchitectureViewerSorter result = method == null || method == IModelEnvironmentUI.SortingMethod.NONE ? null : new NameTypeArchitectureViewerSorter(method);
        return result;
    }

    public String getText(Object element) {
        String result;
        if (!(element instanceof EObject)) {
            return element.toString();
        }
        try {
            result = this._capellaLP.getText(element);
        }
        catch (Exception e) {
            result = super.getText(element);
        }
        return result;
    }

    public static class NameTypeArchitectureViewerSorter
    extends DefaultModelEnvironmentUI.NameTypeViewerSorter {
        private static final List<EClass> ORDERED_ARCHITECTURES = Arrays.asList(OaPackage.eINSTANCE.getOperationalAnalysis(), CtxPackage.eINSTANCE.getSystemAnalysis(), LaPackage.eINSTANCE.getLogicalArchitecture(), PaPackage.eINSTANCE.getPhysicalArchitecture(), EpbsPackage.eINSTANCE.getEPBSArchitecture());

        public NameTypeArchitectureViewerSorter(IModelEnvironmentUI.SortingMethod method) {
            super(method);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result;
            if (e1 instanceof BlockArchitecture && e2 instanceof BlockArchitecture) {
                int pos1 = ORDERED_ARCHITECTURES.indexOf(((EObject)e1).eClass());
                int pos2 = ORDERED_ARCHITECTURES.indexOf(((EObject)e2).eClass());
                result = pos1 - pos2;
            } else {
                result = super.compare(viewer, e1, e2);
            }
            return result;
        }
    }
}

