/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.patterns.ui.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractTemplatePatternSelection;
import org.eclipse.emf.diffmerge.patterns.ui.sirius.util.SiriusUIExtender;
import org.eclipse.emf.diffmerge.patterns.ui.util.IUIExtender;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.ModelSubsetViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.polarsys.capella.common.ui.toolkit.browser.view.ISemanticBrowserViewPart;
import org.polarsys.capella.patterns.ui.Messages;

public class CapellaUIExtender
extends SiriusUIExtender {
    public boolean createNavigationItems(Menu menu, ModelSubsetViewer viewer) {
        this.createShowInSemanticBrowserItem(menu, viewer);
        this.createShowInExplorerItem(menu, viewer);
        return true;
    }

    protected void createShowInExplorerItem(Menu menu, final ModelSubsetViewer viewer) {
        final MenuItem showInExp = new MenuItem(menu, 0);
        showInExp.setText(Messages.CapellaSemanticMapping_ShowInExplorer);
        showInExp.setAccelerator(0x1000011);
        CommonNavigator exp = this.getCapellaAdvanceExplorer(false);
        if (exp != null) {
            showInExp.setImage(exp.getTitleImage());
        }
        showInExp.setEnabled(false);
        viewer.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enable;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                boolean bl = enable = selection.size() == 1;
                if (enable) {
                    Object first = selection.getFirstElement();
                    enable = first instanceof EObject && AbstractTemplatePatternSelection.INSTANCE_FILTER.accepts((EObject)first);
                }
                showInExp.setEnabled(enable);
            }
        });
        showInExp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = viewer.getSelection();
                CommonNavigator innerExp = CapellaUIExtender.this.getCapellaAdvanceExplorer(true);
                if (innerExp != null && selection.size() == 1) {
                    if (showInExp.getImage() == null) {
                        showInExp.setImage(innerExp.getTitleImage());
                    }
                    innerExp.selectReveal((ISelection)selection);
                }
            }
        });
    }

    protected void createShowInSemanticBrowserItem(Menu menu, final ModelSubsetViewer viewer) {
        final MenuItem showInSB = new MenuItem(menu, 0);
        showInSB.setText(Messages.CapellaSemanticMapping_ShowInSemanticBrowser);
        showInSB.setAccelerator(0x1000012);
        ISemanticBrowserViewPart sb = this.getSemanticBrowser(false);
        if (sb != null) {
            showInSB.setImage(sb.getTitleImage());
        }
        showInSB.setEnabled(false);
        viewer.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enable;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                boolean bl = enable = selection.size() == 1;
                if (enable) {
                    Object first = selection.getFirstElement();
                    enable = first instanceof EObject && AbstractTemplatePatternSelection.INSTANCE_FILTER.accepts((EObject)first);
                }
                showInSB.setEnabled(enable);
            }
        });
        showInSB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selection = viewer.getSelection().toList();
                ISemanticBrowserViewPart innerSb = CapellaUIExtender.this.getSemanticBrowser(true);
                if (innerSb != null && selection.size() == 1) {
                    EObject element = (EObject)selection.get(0);
                    if (showInSB.getImage() == null) {
                        showInSB.setImage(innerSb.getTitleImage());
                    }
                    innerSb.setInput((Object)element);
                }
            }
        });
    }

    protected CommonNavigator getCapellaAdvanceExplorer(boolean forceShow) {
        CommonNavigator result = null;
        String viewID = "capella.project.explorer";
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = null;
        if (forceShow) {
            try {
                view = page.showView("capella.project.explorer");
            }
            catch (PartInitException partInitException) {}
        } else {
            view = page.findView("capella.project.explorer");
        }
        if (view instanceof CommonNavigator) {
            result = (CommonNavigator)view;
        }
        return result;
    }

    public Collection<? extends Class<? extends IUIExtender>> getOverridenClasses() {
        return Collections.singleton(SiriusUIExtender.class);
    }

    protected ISemanticBrowserViewPart getSemanticBrowser(boolean forceShow) {
        ISemanticBrowserViewPart result = null;
        String viewID = "org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID";
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = null;
        if (forceShow) {
            try {
                view = page.showView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
            }
            catch (PartInitException partInitException) {}
        } else {
            view = page.findView("org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserID");
        }
        if (view instanceof ISemanticBrowserViewPart) {
            result = (ISemanticBrowserViewPart)view;
        }
        return result;
    }
}

