/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.common.ui.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionController;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionValidateWizardPage;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionWizardPage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.ui.resources.CapellaUIResourcesPlugin;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;

public class LCDecompositionWizard
extends Wizard {
    private DecompositionModel _decompositionModel;
    private LCDecompositionWizardPage _lcDecompositionWizardPage;
    private LCDecompositionValidateWizardPage _lcDecompositionValidateWizardPage;
    private LCDecompositionController _controller;

    public LCDecompositionWizard() {
    }

    public LCDecompositionWizard(DecompositionModel decompModel_p) {
        this.setDecompositionModel(decompModel_p);
        this._lcDecompositionWizardPage = new LCDecompositionWizardPage(this._decompositionModel);
        this._lcDecompositionValidateWizardPage = new LCDecompositionValidateWizardPage(this._decompositionModel);
        this.addPage((IWizardPage)this._lcDecompositionWizardPage);
        this.addPage((IWizardPage)this._lcDecompositionValidateWizardPage);
        this.setNeedsProgressMonitor(true);
    }

    public void initComponents() {
        this._lcDecompositionWizardPage = new LCDecompositionWizardPage(this.getDecompositionModel());
        this._lcDecompositionWizardPage.setController(this.getController());
        this._lcDecompositionValidateWizardPage = new LCDecompositionValidateWizardPage(this.getDecompositionModel());
        this._lcDecompositionValidateWizardPage.setController(this.getController());
        this.addPage((IWizardPage)this._lcDecompositionWizardPage);
        this.addPage((IWizardPage)this._lcDecompositionValidateWizardPage);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        return this._decompositionModel.finishDecomposition();
    }

    public boolean canFinish() {
        boolean decompositionComplete = this._controller.isDecompositionComplete();
        boolean userHasDeletedSubComponent = this._controller.userHasDeletedSubComponent();
        return userHasDeletedSubComponent || decompositionComplete;
    }

    public LCDecompositionController getController() {
        return this._controller;
    }

    public void setController(LCDecompositionController controller_p) {
        this._controller = controller_p;
    }

    public DecompositionModel getDecompositionModel() {
        return this._decompositionModel;
    }

    public void setDecompositionModel(DecompositionModel decompositionModel_p) {
        this._decompositionModel = decompositionModel_p;
    }

    public void trigger() {
        boolean flag = this._controller.isDecompositionComplete();
        this._lcDecompositionWizardPage.setPageComplete(flag);
        this._lcDecompositionValidateWizardPage.setPageComplete(flag);
    }

    public Image getDefaultPageImage() {
        ImageDescriptor pngImageDescriptor = CapellaUIResourcesPlugin.getDefault().getPNGImage(LaPackage.Literals.LOGICAL_COMPONENT);
        Image image = pngImageDescriptor != null ? pngImageDescriptor.createImage() : super.getDefaultPageImage();
        return image;
    }
}

