/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.activities;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.api.ITransposerWorkflow;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class FinalizeTransitionActivity
extends AbstractActivity
implements ITransposerWorkflow {
    public static final String ID = "org.polarsys.capella.core.transition.common.activities.FinalizeTransitionActivity";

    @Override
    public String getActivityIdentifier() {
        return "finalizeTransition";
    }

    @Override
    public IStatus _run(ActivityParameters activityParams) {
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        boolean shouldSave = Boolean.TRUE.equals(context.get((Object)"SAVE_REQUIRED"));
        Resource sourceResource = (Resource)context.get((Object)"_T_S_Res");
        Resource targetResource = (Resource)context.get((Object)"_T_T_Res");
        if (targetResource != sourceResource || shouldSave) {
            Session session = SessionManager.INSTANCE.getSession(targetResource);
            if (session != null) {
                if (session.isOpen()) {
                    session.save((IProgressMonitor)new NullProgressMonitor());
                    LogHelper.getInstance().info(NLS.bind((String)"Session for ''{0}'' has been saved automatically.", (Object)targetResource.getURI()), Messages.Activity_Transition);
                }
            } else {
                try {
                    LogHelper.getInstance().info(NLS.bind((String)"Resource ''{0}'' has been saved automatically.", (Object)targetResource.getURI()), Messages.Activity_Transition);
                    targetResource.save(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    LogHelper.getInstance().warn(exception.getMessage(), Messages.Activity_Transition);
                }
            }
        }
        LogHelper.getInstance().info("Operation has been successful.", Messages.Activity_Transition);
        return Status.OK_STATUS;
    }
}

