/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.core.transition.common.commands.LauncherCommand;

public abstract class CommandHandler
extends AbstractHandler {
    protected Collection<?> getInitialSelection(Object evaluationContext) {
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        return this.getSemanticObjects((Collection)context.getDefaultVariable());
    }

    public Collection<EObject> getSemanticObjects(Collection<?> elements) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Object object : elements) {
            EObject semantic = this.resolveSemanticObject(object);
            if (semantic == null) continue;
            result.add(semantic);
        }
        return result;
    }

    public EObject resolveSemanticObject(Object object) {
        EObject semantic = null;
        if (object != null) {
            Object adapter;
            if (object instanceof EObject) {
                semantic = (EObject)object;
            } else if (object instanceof IAdaptable && (adapter = ((IAdaptable)object).getAdapter(EObject.class)) instanceof EObject) {
                semantic = (EObject)adapter;
            }
        }
        return semantic;
    }

    protected abstract ICommand createCommand(Collection<?> var1, IProgressMonitor var2);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            return this.execute(this.getSelection(event), event.getCommand().getDescription());
        }
        catch (NotDefinedException ex) {
            return this.execute(this.getSelection(event));
        }
    }

    public Object execute(Collection<?> selection) throws ExecutionException {
        return this.execute(selection, "");
    }

    public Object execute(Collection<?> selection, String name) throws ExecutionException {
        try {
            LongRunningListenersRegistry.getInstance().operationStarting(((Object)((Object)this)).getClass());
            ICommand cmd = this.createCommand(selection, (IProgressMonitor)new NullProgressMonitor());
            if (cmd instanceof LauncherCommand) {
                ((LauncherCommand)cmd).setName(name);
            }
            TransactionHelper.getExecutionManager(this.getSemanticObjects(selection)).execute(cmd);
        }
        finally {
            LongRunningListenersRegistry.getInstance().operationEnded(((Object)((Object)this)).getClass());
        }
        return null;
    }

    protected Collection<?> getSelection(ExecutionEvent event) {
        IEvaluationContext context = (IEvaluationContext)event.getApplicationContext();
        Object selection = context.getDefaultVariable();
        if (selection instanceof Collection) {
            return (Collection)selection;
        }
        return Collections.emptyList();
    }
}

