/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.sections;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.core.properties.sections.NamedElementSection;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.properties.Messages;
import org.polarsys.capella.core.data.interaction.properties.controllers.AbstractCapability_AvailableInStatesController;
import org.polarsys.capella.core.data.interaction.properties.controllers.AbstractCapability_InvolvedFunctionalChainsController;
import org.polarsys.capella.core.data.interaction.properties.controllers.AbstractCapability_InvolvedFunctionsController;
import org.polarsys.capella.core.data.interaction.properties.controllers.AbstractCapability_RealizedCapabilitiesController;
import org.polarsys.capella.core.data.interaction.properties.controllers.AbstractCapability_SuperController;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.CompositionMultipleSemanticField;
import org.polarsys.capella.core.ui.properties.fields.ConstraintReferenceGroup;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;

public abstract class AbstractCapabilitySection
extends NamedElementSection {
    private CompositionMultipleSemanticField _superTypes;
    private MultipleSemanticField _realizedFunctionsField;
    private MultipleSemanticField _realizedFunctionalChainsField;
    private MultipleSemanticField _availableInStatesField;
    private MultipleSemanticField _realizedCapabilitiesField;
    private ConstraintReferenceGroup _prePostConditions;
    private boolean _showRealizedCapabilitiesField;

    public AbstractCapabilitySection() {
        this(true);
    }

    public AbstractCapabilitySection(boolean showRealizedCapabilitiesField) {
        this._showRealizedCapabilitiesField = showRealizedCapabilitiesField;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this._prePostConditions = new ConstraintReferenceGroup((Map)ImmutableMap.of((Object)Messages.getString("AbstractCapabilitySection_PreCondition_Label"), (Object)InteractionPackage.Literals.ABSTRACT_CAPABILITY__PRE_CONDITION, (Object)Messages.getString("AbstractCapabilitySection_PostCondition_Label"), (Object)InteractionPackage.Literals.ABSTRACT_CAPABILITY__POST_CONDITION));
        this._prePostConditions.createControls(this._rootParentComposite, this.getWidgetFactory(), this.isDisplayedInWizard());
        this._superTypes = new CompositionMultipleSemanticField((Composite)this.getReferencesGroup(), Messages.getString("AbstractCapabilitySection_SuperType_Label"), this.getWidgetFactory(), (IMultipleSemanticFieldController)new AbstractCapability_SuperController());
        this._superTypes.setDisplayedInWizard(this.isDisplayedInWizard());
        this._realizedFunctionsField = new MultipleSemanticField((Composite)this.getReferencesGroup(), this.getInvolvedFunctionsLabel(), this.getWidgetFactory(), (IMultipleSemanticFieldController)new AbstractCapability_InvolvedFunctionsController());
        this._realizedFunctionsField.setDisplayedInWizard(this.isDisplayedInWizard());
        this._realizedFunctionalChainsField = new MultipleSemanticField((Composite)this.getReferencesGroup(), this.getInvolvedFunctionalChainsLabel(), this.getWidgetFactory(), (IMultipleSemanticFieldController)new AbstractCapability_InvolvedFunctionalChainsController());
        this._realizedFunctionalChainsField.setDisplayedInWizard(this.isDisplayedInWizard());
        this._availableInStatesField = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.getString("AbstractCapabilitySection_AvailableInStates_Label"), this.getWidgetFactory(), (IMultipleSemanticFieldController)new AbstractCapability_AvailableInStatesController());
        this._availableInStatesField.setDisplayedInWizard(this.isDisplayedInWizard());
        if (this._showRealizedCapabilitiesField) {
            this._realizedCapabilitiesField = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.getString("AbstractCapabilitySection_RealizedCapabilities_Label"), this.getWidgetFactory(), (IMultipleSemanticFieldController)new AbstractCapability_RealizedCapabilitiesController());
            this._realizedCapabilitiesField.setDisplayedInWizard(this.isDisplayedInWizard());
        }
    }

    protected String getInvolvedFunctionsLabel() {
        return Messages.getString("AbstractCapabilitySection_RealizedFunctions_Label");
    }

    protected String getInvolvedFunctionalChainsLabel() {
        return Messages.getString("AbstractCapabilitySection_RealizedFunctionalChains_Label");
    }

    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        this._prePostConditions.loadData(capellaElement);
        if (this._superTypes != null) {
            this._superTypes.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_Super(), (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_SuperGeneralizations());
        }
        if (this._availableInStatesField != null) {
            this._availableInStatesField.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_AvailableInStates());
        }
        if (this._realizedFunctionsField != null) {
            this._realizedFunctionsField.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_OwnedAbstractFunctionAbstractCapabilityInvolvements());
        }
        if (this._realizedFunctionalChainsField != null) {
            this._realizedFunctionalChainsField.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_OwnedFunctionalChainAbstractCapabilityInvolvements());
        }
        if (this._realizedCapabilitiesField != null) {
            this._realizedCapabilitiesField.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getAbstractCapability_OwnedAbstractCapabilityRealizations());
        }
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this._superTypes);
        fields.add((AbstractSemanticField)this._availableInStatesField);
        fields.add((AbstractSemanticField)this._realizedFunctionsField);
        fields.add((AbstractSemanticField)this._realizedFunctionalChainsField);
        if (this._realizedCapabilitiesField != null) {
            fields.add((AbstractSemanticField)this._realizedCapabilitiesField);
        }
        fields.addAll(this._prePostConditions.getFields());
        return fields;
    }
}

