/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.sections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.core.properties.sections.NamedElementSection;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.properties.Messages;
import org.polarsys.capella.core.data.interaction.properties.controllers.DataFlowController;
import org.polarsys.capella.core.data.interaction.properties.controllers.DataFlowHelper;
import org.polarsys.capella.core.data.interaction.properties.controllers.ExchangedItemsController;
import org.polarsys.capella.core.data.interaction.properties.controllers.InterfaceController;
import org.polarsys.capella.core.data.interaction.properties.controllers.InterfaceHelper;
import org.polarsys.capella.core.data.interaction.properties.controllers.SequenceMessageController;
import org.polarsys.capella.core.data.interaction.properties.dialogs.DialogProvider;
import org.polarsys.capella.core.data.interaction.properties.fields.MessageKindGroup;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.controllers.ISimpleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.ConstraintReferenceGroup;
import org.polarsys.capella.core.ui.properties.fields.EditableSemanticFieldException;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;
import org.polarsys.capella.core.ui.properties.fields.SimpleEditableSemanticField;

public class SequenceMessageSection
extends NamedElementSection {
    private SimpleEditableSemanticField invokedOperationField;
    private MultipleSemanticField exchangedItemsField;
    private MessageKindGroup messageKindGroup;
    private ConstraintReferenceGroup exchangeContextField;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.namedElementGroup.enableNameField(false);
        Group main = this.getWidgetFactory().createGroup(this._rootParentComposite, "");
        main.setLayout((Layout)new GridLayout(6, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        main.setLayoutData((Object)gd);
        boolean displayedInWizard = this.isDisplayedInWizard();
        this.invokedOperationField = new SimpleEditableSemanticField((Composite)main, Messages.getString("SequenceMessage.InvokedOperationLabel"), this.getWidgetFactory(), "", null){

            protected void handleDeleteButtonClicked() {
                AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                    public void run() {
                        SequenceMessageController.resetValue(_semanticElement);
                        this.setValueTextField(_semanticElement);
                        SequenceMessageSection.this.refresh();
                    }
                };
                this.executeCommand((ICommand)command);
            }

            protected void handleEditButtonClicked() throws EditableSemanticFieldException {
                super.handleEditButtonClicked();
                SequenceMessageSection.this.refresh();
            }

            protected void handleOpenButtonClicked(Button button) {
                AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                    public void run() {
                        SequenceMessage message = (SequenceMessage)_semanticElement;
                        Scenario s = (Scenario)message.eContainer();
                        if (_controller instanceof InterfaceController) {
                            EObject affectedElement = DialogProvider.openOperationDialog((SequenceMessage)_semanticElement);
                            if (affectedElement != null) {
                                InterfaceHelper.affectExchangeItem(message, (AbstractEventOperation)((ExchangeItemAllocation)affectedElement));
                                ComponentExt.ensureUseAndImplementsForOperation((SequenceMessage)message, (ExchangeItemAllocation)((ExchangeItemAllocation)affectedElement), (boolean)false, null);
                            }
                        } else if (_controller instanceof DataFlowController) {
                            boolean isFunctionalScenario;
                            EObject affectedElement = null;
                            affectedElement = ScenarioExt.isFunctionalScenario((Scenario)s) ? DialogProvider.openFunctionalExchangeDialog(message, "FEF") : ((isFunctionalScenario = ScenarioExt.isDataFlowFunctionalScenario((Scenario)s)) ? DialogProvider.openFunctionalExchangeDialog(message, "FE") : DialogProvider.openFunctionalExchangeDialog(message, "CE"));
                            if (affectedElement != null) {
                                DataFlowHelper.affectDataflowToMessage(message, (AbstractEventOperation)affectedElement);
                            }
                        }
                    }

                    public String getName() {
                        return "Edit " + _semanticElement.eGet((EStructuralFeature)ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name());
                    }
                };
                this.executeCommand((ICommand)command);
                SequenceMessageSection.this.refresh();
            }
        };
        this.invokedOperationField.setDisplayedInWizard(displayedInWizard);
        this.exchangedItemsField = new MultipleSemanticField((Composite)main, Messages.getString("SequenceMessage.ExchangedItemsLabel"), this.getWidgetFactory(), (IMultipleSemanticFieldController)new ExchangedItemsController());
        this.exchangedItemsField.setDisplayedInWizard(displayedInWizard);
        this.messageKindGroup = new MessageKindGroup(this._rootParentComposite, this.getWidgetFactory(), false);
        this.messageKindGroup.setDisplayedInWizard(displayedInWizard);
        this.exchangeContextField = new ConstraintReferenceGroup(Collections.singletonMap(Messages.getString("SequenceMessage.ExchangeContextLabel"), InteractionPackage.Literals.SEQUENCE_MESSAGE__EXCHANGE_CONTEXT));
        this.exchangeContextField.createControls(this._rootParentComposite, this.getWidgetFactory(), displayedInWizard);
    }

    public void loadData(EObject capellaElement) {
        super.loadData(capellaElement);
        Scenario scenario = (Scenario)((SequenceMessage)capellaElement).eContainer();
        if (scenario != null) {
            if (scenario.getKind() == ScenarioKind.INTERFACE) {
                this.invokedOperationField.setController((ISimpleSemanticFieldController)new InterfaceController());
                this.invokedOperationField.enableEditButton(true);
                this.invokedOperationField.setLabel(Messages.getString("SequenceMessage.InvokedOperationLabel"));
                this.exchangedItemsField.setEnabled(false);
                this.exchangedItemsField.setVisible(false);
            } else if (scenario.getKind() == ScenarioKind.DATA_FLOW) {
                this.invokedOperationField.setController((ISimpleSemanticFieldController)new DataFlowController());
                this.invokedOperationField.enableEditButton(true);
                this.invokedOperationField.setLabel(Messages.getString("SequenceMessage.InvokedExchangeLabel"));
                this.exchangedItemsField.setEnabled(true);
                this.exchangedItemsField.setVisible(true);
            } else if (scenario.getKind() == ScenarioKind.INTERACTION) {
                this.invokedOperationField.setController((ISimpleSemanticFieldController)new DataFlowController());
                this.invokedOperationField.enableEditButton(true);
                this.invokedOperationField.setLabel(Messages.getString("SequenceMessage.InvokedInteractionLabel"));
                this.exchangedItemsField.setEnabled(true);
                this.exchangedItemsField.setVisible(true);
            } else if (scenario.getKind() == ScenarioKind.FUNCTIONAL) {
                this.invokedOperationField.setController((ISimpleSemanticFieldController)new DataFlowController());
                this.invokedOperationField.enableEditButton(true);
                this.invokedOperationField.setLabel(Messages.getString("SequenceMessage.InvokedExchangeLabel"));
                this.exchangedItemsField.setEnabled(true);
                this.exchangedItemsField.setVisible(true);
            }
        }
        this.messageKindGroup.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getSequenceMessage_Kind());
        this.invokedOperationField.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getEventReceiptOperation_Operation());
        this.exchangedItemsField.loadData(capellaElement, (EStructuralFeature)InteractionPackage.eINSTANCE.getSequenceMessage_ExchangedItems());
        this.exchangeContextField.loadData(capellaElement);
    }

    public boolean select(Object toTest) {
        EObject eObjectToTest = super.selection(toTest);
        return eObjectToTest != null && eObjectToTest.eClass() == InteractionPackage.eINSTANCE.getSequenceMessage();
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> fields = new ArrayList<AbstractSemanticField>();
        fields.addAll(super.getSemanticFields());
        fields.add((AbstractSemanticField)this.exchangedItemsField);
        fields.add((AbstractSemanticField)this.invokedOperationField);
        fields.add((AbstractSemanticField)this.messageKindGroup);
        fields.addAll(this.exchangeContextField.getFields());
        return fields;
    }
}

