/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ImageDescriptorRegistry {
    private Map<ImageDescriptor, Image> fRegistry = Collections.synchronizedMap(new HashMap(10));
    private Display fDisplay = PlatformUI.getWorkbench().getDisplay();

    public ImageDescriptorRegistry() {
        Assert.isNotNull((Object)this.fDisplay);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = this.fRegistry.get(descriptor)) != null) {
            return result;
        }
        result = descriptor.createImage();
        if (result != null) {
            this.fRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.fRegistry.values()) {
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
        this.fDisplay.asyncExec(new Runnable(){

            public void run() {
                ImageDescriptorRegistry.this.fDisplay.disposeExec(new Runnable(){

                    public void run() {
                        ImageDescriptorRegistry.this.dispose();
                    }
                });
            }
        });
    }
}

